/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportInfo;

public final class TransportMessage {
    public static final byte VERSION = 1;
    public static final int PACKET_SIZE = 1400;
    public static final int HEADER_SIZE = 21;
    public static final int BODY_SIZE = 1379;
    public static final byte DEFAULT_TTL = 10;
    public static final int CONTENT_OFFSET = 21;
    public final byte[] body = new byte[1400];
    private TransportInfo transportInfo = null;

    private TransportMessage() {
    }

    public static TransportMessage createMessage(RoxAddress destination) {
        TransportMessage msg = new TransportMessage();
        msg.setVersion((byte)1);
        msg.setTTL((byte)10);
        msg.setDestinationId(destination);
        return msg;
    }

    static TransportMessage createEncapsulatedMessage(byte[] bytes, int off, int len) {
        TransportMessage msg = new TransportMessage();
        System.arraycopy(bytes, off, msg.body, 0, len);
        return msg;
    }

    static TransportMessage createMessage() {
        TransportMessage msg = new TransportMessage();
        return msg;
    }

    public byte getVersion() {
        return this.body[0];
    }

    public int getLength() {
        int length = (this.body[1] & 0xFF) << 24 | (this.body[2] & 0xFF) << 16 | (this.body[3] & 0xFF) << 8 | this.body[4] & 0xFF;
        return length;
    }

    public byte getTTL() {
        return this.body[5];
    }

    public RoxAddress getSourceId() {
        byte[] b = new byte[7];
        System.arraycopy(this.body, 6, b, 0, 7);
        return new RoxAddress(b);
    }

    public RoxAddress getDestinationId() {
        byte[] b = new byte[7];
        System.arraycopy(this.body, 13, b, 0, 7);
        return new RoxAddress(b);
    }

    public byte getType() {
        return this.body[20];
    }

    void setVersion(byte version) {
        this.body[0] = version;
    }

    public void setLength(int length) {
        this.body[1] = (byte)(0xFF & length >> 24);
        this.body[2] = (byte)(0xFF & length >> 16);
        this.body[3] = (byte)(0xFF & length >> 8);
        this.body[4] = (byte)(0xFF & length);
    }

    void setTTL(byte ttl) {
        this.body[5] = ttl;
    }

    void setSourceId(RoxAddress source) {
        System.arraycopy(source.getBytes(), 0, this.body, 6, 7);
    }

    void setDestinationId(RoxAddress dest) {
        System.arraycopy(dest.getBytes(), 0, this.body, 13, 7);
    }

    void setType(byte type) {
        this.body[20] = type;
    }

    void setTransportInfo(TransportInfo info) {
        this.transportInfo = info;
    }

    public TransportInfo getTransportInfo() {
        return this.transportInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TransportMessage");
        sb.append(":version=").append(this.getVersion());
        sb.append(":length=").append(this.getLength());
        sb.append(":TTL=").append(this.getTTL());
        sb.append(":SourceId=").append(this.getSourceId());
        sb.append(":DestinationId=").append(this.getDestinationId());
        sb.append(":Type=").append(this.getType());
        return sb.toString();
    }
}

