/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.NoProtocolManager;
import com.raplix.rolloutexpress.net.transport.NoRouteToHost;
import com.raplix.rolloutexpress.net.transport.PacketHandler;
import com.raplix.rolloutexpress.net.transport.ProtocolManager;
import com.raplix.rolloutexpress.net.transport.RouteTable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SSLFactory;
import com.raplix.rolloutexpress.net.transport.SetupException;
import com.raplix.rolloutexpress.net.transport.SshProxyPacketHandler;
import com.raplix.rolloutexpress.net.transport.TransportControl;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.net.transport.TransportMessage;
import com.raplix.rolloutexpress.net.transport.TransportServices;
import com.raplix.rolloutexpress.net.transport.TransportServicesImpl;
import com.raplix.rolloutexpress.net.transport.UnsupportedVersionException;
import com.raplix.rolloutexpress.net.transport.config.ConfigServices;
import com.raplix.rolloutexpress.net.transport.config.HostUpdateManager;
import com.raplix.rolloutexpress.net.transport.config.NodeConfigManager;
import com.raplix.rolloutexpress.net.transport.config.RouteTranslationException;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigException;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public final class TransportManager {
    private ProtocolManager[] protocolManagers = new ProtocolManager[127];
    private ConnectionManager cMgr;
    private RouteTable routeTable;
    private TransportControl control;
    private NodeConfigManager configManager;
    private HostUpdateManager huManager;
    private PacketHandler packetHandler = null;
    private NetSubsystem netSubsystem;
    private RoxAddress nodeAddress;
    private RoxAddress mMSAddress;
    private boolean allowClientNodeAddress = false;
    private boolean mIsCompatibilityMode = false;
    private boolean mInitMSAddressFromConfig = false;
    private boolean mDisableForwarding = false;

    public static TransportManager createTransportForMS(NetSubsystem nss) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, false);
        tManager.nodeAddress = RoxAddress.local;
        tManager.allowClientNodeAddress = false;
        tManager.huManager = new HostUpdateManager(nss);
        tManager.mDisableForwarding = true;
        return tManager;
    }

    public static TransportManager createTransportForLocal(NetSubsystem nss) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.cMgr = ConnectionManager.createForLocal(nss, tManager);
        tManager.nodeAddress = RoxAddress.local;
        tManager.setMSAddress(tManager.nodeAddress);
        tManager.allowClientNodeAddress = false;
        return tManager;
    }

    public static TransportManager createTransportForNode(NetSubsystem nss) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, true);
        tManager.configManager = new NodeConfigManager(nss);
        tManager.nodeAddress = tManager.configManager.initTransport(tManager.getRouteTable(), tManager.getConnectionManager(), false);
        if (tManager.nodeAddress == null) {
            throw new TransportException(NetMessageCode.TRNS_NODE_NO_SERVER_ADDR);
        }
        tManager.allowClientNodeAddress = false;
        return tManager;
    }

    public static TransportManager createTransportForNode(NetSubsystem nss, InputStream is, OutputStream os) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, is, os, nss.getLocalAddress(), nss.getRemoteAddress());
        tManager.configManager = new NodeConfigManager(nss);
        tManager.configManager.initTransport(tManager.getRouteTable(), tManager.getConnectionManager(), true);
        tManager.nodeAddress = nss.getLocalAddress();
        tManager.allowClientNodeAddress = false;
        return tManager;
    }

    public static TransportManager createTransportForClient(NetSubsystem nss) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, false);
        ConnectionSetupAttribute[] clientConn = nss.getClientConnAttributes();
        for (int i = 0; i < clientConn.length; ++i) {
            tManager.cMgr.addClientConnection(clientConn[i]);
        }
        tManager.nodeAddress = RoxAddress.local;
        tManager.allowClientNodeAddress = true;
        return tManager;
    }

    public static TransportManager createTransportForProxy(NetSubsystem nss, InputStream is, OutputStream os) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, is, os, nss.getLocalAddress(), nss.getRemoteAddress());
        ConnectionSetupAttribute[] clientConn = nss.getClientConnAttributes();
        if (clientConn.length != 1) {
            throw new ConfigurationException("net.transport.inv_proxy_config", new String[]{String.valueOf(clientConn.length)});
        }
        for (int i = 0; i < clientConn.length; ++i) {
            tManager.cMgr.addClientConnection(clientConn[i]);
        }
        RoxAddress msAddr = new RoxAddress(clientConn[0].getAddress(), clientConn[0].getPort());
        tManager.nodeAddress = nss.getLocalAddress();
        tManager.allowClientNodeAddress = false;
        tManager.packetHandler = new SshProxyPacketHandler(msAddr, nss.getLocalAddress(), nss.getRemoteAddress(), tManager.cMgr);
        return tManager;
    }

    public static TransportManager createTransportForTest(NetSubsystem nss) throws TransportException, ConfigurationException {
        int i;
        TransportManager tManager = new TransportManager(nss);
        tManager.initRouteTable(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, true);
        ConnectionSetupAttribute[] setupAttrib = nss.getClientConnAttributes();
        for (i = 0; i < setupAttrib.length; ++i) {
            tManager.cMgr.addClientConnection(setupAttrib[i]);
        }
        setupAttrib = nss.getServerConnAttributes();
        for (i = 0; i < setupAttrib.length; ++i) {
            tManager.cMgr.addServerConnection(setupAttrib[i]);
        }
        if (setupAttrib.length > 0) {
            tManager.nodeAddress = new RoxAddress(setupAttrib[0].getAddress(), setupAttrib[0].getPort());
        } else {
            tManager.nodeAddress = RoxAddress.local;
            tManager.allowClientNodeAddress = true;
            tManager.mInitMSAddressFromConfig = true;
        }
        if (Logger.isInfoEnabled(TransportManager.class)) {
            Logger.info("Transport Manager initialized", TransportManager.class);
        }
        return tManager;
    }

    public static TransportManager createTransportForTest(NetSubsystem nss, InputStream is, OutputStream os) throws TransportException, ConfigurationException {
        TransportManager tManager = new TransportManager(nss);
        tManager.initRouteTable(nss);
        tManager.cMgr = ConnectionManager.create(nss, tManager, is, os, nss.getLocalAddress(), nss.getRemoteAddress());
        ConnectionSetupAttribute[] setupAttrib = nss.getClientConnAttributes();
        for (int i = 0; i < setupAttrib.length; ++i) {
            tManager.cMgr.addClientConnection(setupAttrib[i]);
        }
        tManager.nodeAddress = nss.getLocalAddress();
        if (Logger.isInfoEnabled(TransportManager.class)) {
            Logger.info("Transport Manager initialized", TransportManager.class);
        }
        return tManager;
    }

    private TransportManager(NetSubsystem nss) throws TransportException, ConfigurationException {
        this.netSubsystem = nss;
        this.control = new TransportControl(nss, this);
        this.registerProtocolManager(this.control);
        this.routeTable = new RouteTable();
    }

    private void initRouteTable(NetSubsystem nss) throws ConfigurationException {
        Hashtable routes = nss.getRoutes();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Routes:" + routes, this);
        }
        Enumeration enu = routes.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            this.routeTable.addStaticRoute((RoxAddress)key, (RoxAddress)routes.get(key));
        }
    }

    private void startThreads() {
        this.cMgr.startAllThreads();
    }

    public void postInit() throws ConfigurationException {
        if (this.huManager != null) {
            try {
                this.nodeAddress = this.huManager.initTransport(this.routeTable, this.cMgr);
                this.setMSAddress(this.nodeAddress);
            }
            catch (RouteTranslationException rte) {
                throw new ConfigurationException("net.transport.route_tree_init_error", (Throwable)rte);
            }
            catch (UnsupportedSubsystemException use) {
                throw new ConfigurationException("net.transport.hostdb_not_available", (Throwable)use);
            }
            catch (TransportException te) {
                throw new ConfigurationException("net.transport.transport_init_failed", (Throwable)te);
            }
            catch (TransportConfigException tce) {
                throw new ConfigurationException("net.transport.transport_init_failed", (Throwable)tce);
            }
        }
        if (this.mInitMSAddressFromConfig) {
            try {
                this.setMSAddress(this.netSubsystem.getMSAddress());
            }
            catch (ConfigurationException ignored) {
            }
            catch (TransportException transportException) {
                // empty catch block
            }
        }
        this.startThreads();
    }

    public void registerRemoteInterfaces(RPCManager rpcManager) throws RPCException {
        if (this.configManager != null) {
            rpcManager.registerService(ConfigServices.class, this.configManager);
        }
        if (this.huManager != null) {
            rpcManager.registerService(TransportServices.class, new TransportServicesImpl(this));
        }
    }

    public void registerProtocolManager(ProtocolManager pMgr) throws TransportException {
        byte id = pMgr.getProtocolId();
        if (id >= 0 && id < this.protocolManagers.length) {
            if (this.protocolManagers[id] != null) {
                throw new TransportException(NetMessageCode.TRNS_PROTOCOL_ID_CLASH, (Object[])new String[]{pMgr.toString(), this.protocolManagers[id].toString(), String.valueOf(id)});
            }
        } else {
            throw new TransportException(NetMessageCode.TRNS_REG_PROTOCOL_ID_ILLEGAL, (Object[])new String[]{pMgr.toString(), String.valueOf(id)});
        }
        this.protocolManagers[id] = pMgr;
        pMgr.registeredProtocol(this);
    }

    void handleMessage(TransportMessage msg, Connection conn) {
        block23: {
            try {
                if (msg.getVersion() != 1) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Protocol Violation, Aborting connection:Invalid version:" + msg.getVersion(), this);
                    }
                    throw new UnsupportedVersionException(NetMessageCode.TRNS_UNSUPPORTED_VERSION, msg.getVersion());
                }
                if (this.packetHandler != null && this.packetHandler.handlePacket(msg, conn)) {
                    return;
                }
                if (conn != null && conn.getTransportInfo().isClientSide()) {
                    RoxAddress connAddress = conn.getRemoteId();
                    RoxAddress nextHop = null;
                    try {
                        nextHop = this.routeTable.getNextHop(msg.getSourceId());
                    }
                    catch (NoRouteToHost ignored) {
                        // empty catch block
                    }
                    if (!ObjectUtil.equals(connAddress, nextHop)) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Ignoring Packet:Packet received from remote endpoint:" + connAddress + ":" + ":with source address:" + msg.getSourceId() + ":when its expected on connection:" + nextHop, this);
                        }
                        return;
                    }
                }
                if (conn == null) {
                    msg.setTransportInfo(TransportInfo.LOCAL);
                } else {
                    msg.setTransportInfo(conn.getTransportInfo());
                }
                if (this.cMgr.isLocal(msg.getDestinationId())) {
                    this.getProtocolManager(msg.getType()).receiveMessage(msg);
                } else {
                    if (this.mDisableForwarding) {
                        throw new TransportException(NetMessageCode.TRNS_FWD_DISABLED);
                    }
                    msg.setTTL((byte)(msg.getTTL() - 1));
                    if (msg.getTTL() > 0) {
                        Connection targetConnection = this.cMgr.getConnectionTo(this.routeTable.getNextHop(msg.getDestinationId()));
                        this.checkP2PCommunication(msg, targetConnection.getTransportInfo());
                        targetConnection.send(msg);
                    } else {
                        this.errorWithMessage(msg, (byte)6, null);
                    }
                }
            }
            catch (NoRouteToHost nrth) {
                this.errorWithMessage(msg, (byte)1, nrth);
            }
            catch (SetupException se) {
                this.errorWithMessage(msg, (byte)5, se);
            }
            catch (NoProtocolManager npm) {
                this.errorWithMessage(msg, (byte)2, npm);
            }
            catch (MessageNotExpected mne) {
                this.errorWithMessage(msg, (byte)3, mne);
            }
            catch (UnsupportedVersionException uve) {
                this.errorWithMessage(msg, (byte)7, uve);
            }
            catch (TransportException te) {
                this.errorWithMessage(msg, (byte)5, te);
            }
            catch (Exception e) {
                this.errorWithMessage(msg, (byte)8, e);
                if (!Logger.isErrorEnabled(this)) break block23;
                Logger.error("Unexpected Exception in handleMessage():" + msg, e, this);
            }
        }
    }

    private void checkP2PCommunication(TransportMessage msg, TransportInfo inDestConnInfo) throws TransportException {
        if (TransportInfo.CLIENT_SIDE.equals(msg.getTransportInfo()) && TransportInfo.CLIENT_SIDE.equals(inDestConnInfo)) {
            throw new TransportException(NetMessageCode.TRNS_FWD_P2P_DISABLED);
        }
    }

    void noConnections() {
        this.netSubsystem.getApplication().closedAllConnections();
    }

    void closedMainConnection() {
        this.netSubsystem.getApplication().closedMainConnection();
    }

    void sendMessage(TransportMessage msg) throws TransportException {
        if (this.cMgr.isLocal(msg.getDestinationId())) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Local message:" + msg.getDestinationId(), this);
            }
            msg.setSourceId(msg.getDestinationId());
            this.handleMessage(msg, null);
            return;
        }
        Connection c = this.cMgr.getConnectionTo(this.routeTable.getNextHop(msg.getDestinationId()));
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Sending message:" + msg + ":on:" + c, this);
        }
        msg.setSourceId(c.getLocalId());
        c.send(msg);
    }

    ProtocolManager getProtocolManager(byte protocolId) throws NoProtocolManager {
        if (protocolId < 0 || protocolId >= this.protocolManagers.length) {
            throw new NoProtocolManager(NetMessageCode.TRNS_GET_PROTOCOL_ID_ILLEGAL, (Object[])new String[]{String.valueOf(protocolId)});
        }
        ProtocolManager pMgr = this.protocolManagers[protocolId];
        if (pMgr == null) {
            throw new NoProtocolManager(NetMessageCode.TRNS_PROTOCOL_MGR_NO_FOUND, (Object[])new String[]{String.valueOf(protocolId)});
        }
        return pMgr;
    }

    private void errorWithMessage(TransportMessage msg, byte errorType, Exception e) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("error dealing with packet:" + msg + ":errType:" + errorType, e, this);
        }
        this.control.transportError(msg, errorType, e);
    }

    void undeliveredMessage(TransportMessage msg, Exception ex) {
        this.errorWithMessage(msg, (byte)4, ex);
    }

    ConnectionManager getConnectionManager() {
        return this.cMgr;
    }

    RouteTable getRouteTable() {
        return this.routeTable;
    }

    public void shutdown() {
        this.cMgr.shutdownConnections();
    }

    public TransportControl getControl() {
        return this.control;
    }

    public RoxAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public boolean isLocal(RoxAddress roxAddress) {
        return this.cMgr.isLocal(roxAddress);
    }

    public boolean isStdIOInvoked() {
        return this.cMgr.isIOConnManagerInit();
    }

    public boolean requiresInteractiveInit() {
        try {
            SSLFactory.init(this.netSubsystem, true);
            return false;
        }
        catch (TransportException e) {
            return true;
        }
    }

    public int getNumActiveConnections() {
        return this.cMgr.getNumActiveConnections();
    }

    public HostUpdateManager getHostUpdateManager() throws SetupException {
        if (this.huManager == null) {
            throw new SetupException(NetMessageCode.TRNS_NO_HOST_UPDATE_MANAGER);
        }
        return this.huManager;
    }

    public boolean getIsCompatibilityMode() {
        return this.mIsCompatibilityMode;
    }

    HashSet getCompatibleVersions() {
        return this.netSubsystem.getApplication().getCompatibleVersions();
    }

    void setClientNodeAddress(RoxAddress ra) {
        if (this.allowClientNodeAddress && this.nodeAddress.equals(RoxAddress.local)) {
            this.nodeAddress = ra;
        }
    }

    void setCompatibilityMode(boolean inMode) {
        if (Logger.isInfoEnabled(this)) {
            Logger.info("Setting compatibility Mode:" + inMode, this);
        }
        this.mIsCompatibilityMode = inMode;
    }

    void unsetClientNodeAddress(RoxAddress ra) {
        if (this.allowClientNodeAddress && this.nodeAddress.equals(ra)) {
            this.nodeAddress = RoxAddress.local;
        }
    }

    public RoxAddress getMSAddress() {
        return this.mMSAddress;
    }

    void setMSAddress(RoxAddress inMSAddress) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Setting MS Address:" + inMSAddress, this);
        }
        this.mMSAddress = inMSAddress;
    }

    NetSubsystem getNetSubsystem() {
        return this.netSubsystem;
    }
}

