/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.transport.FailureCodes;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportMessage;

final class TransportControlMessage
implements FailureCodes {
    public static final int HEADER_SIZE = 4;
    public static final byte TYPE_PING_REQUEST = 1;
    public static final byte TYPE_PING_REPLY = 2;
    public static final byte TYPE_ERROR = 4;
    public static final int CONTENT_OFFSET = 25;
    public static final int ENCAPSULATED_MSG_SIZE = 32;
    public static final int EXTRA_BYTES_OFFSET = 57;
    public static final int MAX_EXTRA_BYTES = 1000;
    private TransportMessage packet;

    TransportControlMessage(TransportMessage msg) {
        this.packet = msg;
    }

    TransportControlMessage(RoxAddress destinationId) {
        this.packet = TransportMessage.createMessage(destinationId);
    }

    void setType(byte b) {
        this.packet.body[21] = b;
    }

    public byte getType() {
        return this.packet.body[21];
    }

    void setCode(byte b) {
        this.packet.body[21 + 1] = b;
    }

    public byte getCode() {
        return this.packet.body[21 + 1];
    }

    void setInteractionId(short interId) {
        int offset = 23;
        this.packet.body[offset++] = (byte)(0xFF & interId >> 8);
        this.packet.body[offset] = (byte)(0xFF & interId);
    }

    public short getInteractionId() {
        int offset = 23;
        short interId = (short)((this.packet.body[offset++] & 0xFF) << 8 | this.packet.body[offset] & 0xFF);
        return interId;
    }

    void setEncapsulatedMessage(TransportMessage msg) {
        System.arraycopy(msg.body, 0, this.packet.body, 25, 32);
    }

    public TransportMessage getEncapsulatedMessage() {
        if (this.getBodyLength() <= 32) {
            return null;
        }
        return TransportMessage.createEncapsulatedMessage(this.packet.body, 25, 32);
    }

    void setExtraBytes(String s) {
        byte[] b = s.getBytes();
        this.setExtraBytes(b);
    }

    void setExtraBytes(byte[] b) {
        int l = b.length < 1000 ? b.length : 1000;
        System.arraycopy(b, 0, this.packet.body, 57, l);
        this.setBodyLength(32 + l);
    }

    public String getExtraBytesAsString() {
        int l = this.getBodyLength();
        if (l > 32) {
            return new String(this.getBody(), 57, l - 32);
        }
        return null;
    }

    byte[] getExtraBytes() {
        int len = this.getBodyLength();
        if (len > 32) {
            byte[] b = new byte[len - 32];
            System.arraycopy(this.getBody(), 57, b, 0, b.length);
            return b;
        }
        return null;
    }

    public boolean isPingRequest() {
        return (this.getType() & 1) > 0;
    }

    public boolean isPingReply() {
        return (this.getType() & 2) > 0;
    }

    public boolean isError() {
        return (this.getType() & 4) > 0;
    }

    void setBodyLength(int l) {
        this.packet.setLength(4 + l);
    }

    int getBodyLength() {
        return this.packet.getLength() - 4;
    }

    byte[] getBody() {
        return this.packet.body;
    }

    TransportMessage getPacket() {
        return this.packet;
    }

    public static String getCodeString(int code) {
        if (code >= 0 && code < FAULT_CODE_STRINGS.length) {
            return FAULT_CODE_STRINGS[code];
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("Packet:").append(this.packet).append(":Control:Type[").append(this.getType()).append("]:");
        sb.append(this.isPingRequest() ? "PingReq:" : (this.isPingReply() ? "PingRep:" : (this.isError() ? "Error:" : "Invalid:")));
        sb.append("Code:").append(TransportControlMessage.getCodeString(this.getCode()));
        sb.append(":IntId:").append(this.getInteractionId()).append(":Encap:");
        sb.append(this.getEncapsulatedMessage()).append(":Extra:");
        sb.append(this.getExtraBytesAsString());
        return sb.toString();
    }
}

