/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.HostNotFound;
import com.raplix.rolloutexpress.net.transport.NoProtocolManager;
import com.raplix.rolloutexpress.net.transport.NoRouteToHost;
import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.ProtocolManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TimedOut;
import com.raplix.rolloutexpress.net.transport.TraceFailed;
import com.raplix.rolloutexpress.net.transport.TraceResult;
import com.raplix.rolloutexpress.net.transport.TransportControlMessage;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.rolloutexpress.net.transport.TransportMessage;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;

public final class TransportControl
extends ProtocolManager {
    private TransportManager tManager;
    public static byte PROTOCOL_ID = 0;
    private final int INTERACTION_TIMEOUT;
    private Hashtable interactions = new Hashtable();
    private short interactionCounter = 1;

    TransportControl(NetSubsystem nss, TransportManager tMgr) throws ConfigurationException {
        this.tManager = tMgr;
        this.INTERACTION_TIMEOUT = nss.getConfigTransportControlInteractionTimeout();
    }

    public byte getProtocolId() {
        return PROTOCOL_ID;
    }

    protected void errorDeliveringMessage(TransportMessage originalMessage, ErrorDetails errDetails) {
        TransportControlMessage tcm = new TransportControlMessage(originalMessage);
        if (tcm.isPingRequest()) {
            Short interId = new Short(tcm.getInteractionId());
            Interaction inter = (Interaction)this.interactions.get(interId);
            if (inter != null) {
                PingResult pr = new PingResult(errDetails.getFaultNode(), errDetails.getFaultCode(), errDetails.getFaultString(), originalMessage.getTTL());
                inter.notifyWaiter(pr);
                return;
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Ping request error response for unknown interaction:" + tcm, this);
            }
            return;
        }
        if (Logger.isErrorEnabled(this)) {
            Logger.error("Error delivering control message:" + originalMessage + ":Details:" + errDetails, this);
        }
    }

    protected void receiveMessage(TransportMessage msg) {
        TransportControlMessage tcm = new TransportControlMessage(msg);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Received Control Message:" + tcm, this);
        }
        byte type = tcm.getType();
        if (tcm.isPingRequest()) {
            this.handlePingRequest(tcm);
        } else if (tcm.isPingReply()) {
            this.handlePingReply(tcm);
        } else if (tcm.isError()) {
            this.handleErrorPacket(tcm);
        } else if (Logger.isErrorEnabled(this)) {
            Logger.error("Unexpected packet type in receiveMessage" + tcm, this);
        }
    }

    private void handlePingRequest(TransportControlMessage tcm) {
        block2: {
            TransportControlMessage replyMsg = new TransportControlMessage(tcm.getPacket().getSourceId());
            replyMsg.setType((byte)2);
            replyMsg.setInteractionId(tcm.getInteractionId());
            replyMsg.setExtraBytes("doing good!");
            try {
                this.sendMessage(replyMsg.getPacket());
            }
            catch (TransportException te) {
                if (!Logger.isWarnEnabled(this)) break block2;
                Logger.warn("Error replying to ping:" + tcm, te, this);
            }
        }
    }

    private void handlePingReply(TransportControlMessage tcm) {
        Short interId = new Short(tcm.getInteractionId());
        Interaction inter = (Interaction)this.interactions.get(interId);
        if (inter != null) {
            PingResult pr = new PingResult(tcm.getPacket().getSourceId(), tcm.getPacket().getTTL());
            inter.notifyWaiter(pr);
        } else if (Logger.isWarnEnabled(this)) {
            Logger.warn("Ping reply for unknown interaction:" + tcm + ":tbl:" + this.interactions, this);
        }
    }

    private void handleErrorPacket(TransportControlMessage tcm) {
        block5: {
            try {
                TransportMessage encap = tcm.getEncapsulatedMessage();
                if (encap != null) {
                    ProtocolManager pm = this.tManager.getProtocolManager(encap.getType());
                    ErrorDetails errDetail = new ErrorDetails(tcm.getCode(), tcm.getExtraBytesAsString(), tcm.getPacket().getSourceId());
                    pm.errorDeliveringMessage(encap, errDetail);
                } else if (Logger.isWarnEnabled(this)) {
                    Logger.warn("No encapsulated message,dunno what to do" + tcm, this);
                }
            }
            catch (NoProtocolManager npm) {
                if (!Logger.isWarnEnabled(this)) break block5;
                Logger.warn("No protocol manager for the error control message" + tcm, npm, this);
            }
        }
    }

    void transportError(TransportMessage msg, byte code, Exception e) {
        block8: {
            try {
                TransportControlMessage tcm = null;
                if (msg.getType() == this.getProtocolId() && (tcm = new TransportControlMessage(msg)).isError()) {
                    if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Error delivering control message:" + tcm + ":code:" + code, e, this);
                    }
                    return;
                }
                tcm = new TransportControlMessage(msg.getSourceId());
                tcm.setType((byte)4);
                tcm.setCode(code);
                tcm.setEncapsulatedMessage(msg);
                String errMsg = e == null ? "TransportError" : this.getExceptionMessage(e);
                tcm.setExtraBytes(errMsg);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Sending err packet:" + tcm, this);
                }
                this.sendMessage(tcm.getPacket());
            }
            catch (TransportException te) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Error handling transport error:", te, this);
                }
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Original error with msg:" + msg, e, this);
                }
            }
            catch (Exception ex) {
                if (!Logger.isErrorEnabled(this)) break block8;
                Logger.error("Unexpected exception handling transport error:", ex, this);
            }
        }
    }

    public PingResult ping(RoxAddress destination) throws TransportException, HostNotFound {
        this.checkAddressExistence(destination);
        try {
            Interaction interaction = this.doPing(destination, (byte)-1);
            interaction.waitForResponse();
            return interaction.getResult();
        }
        catch (TransportException te) {
            return new PingResult(destination, 5, this.getExceptionMessage(te), 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingAsync(RoxAddress destination) throws TransportException, HostNotFound {
        this.checkAddressExistence(destination);
        Interaction interaction = null;
        try {
            interaction = this.doPing(destination, (byte)-1);
        }
        finally {
            if (interaction != null) {
                interaction.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interaction doPing(RoxAddress destination, byte ttl) throws TransportException {
        TransportControlMessage tcm = new TransportControlMessage(destination);
        tcm.setType((byte)1);
        tcm.setCode((byte)0);
        if (ttl > 0) {
            tcm.getPacket().setTTL(ttl);
        }
        Short interId = new Short(this.allocateInteractionId());
        tcm.setInteractionId(interId);
        tcm.setExtraBytes("Howdy?");
        Interaction interaction = new Interaction(interId);
        this.interactions.put(interId, interaction);
        boolean sendFailed = true;
        try {
            this.sendMessage(tcm.getPacket());
            sendFailed = false;
        }
        finally {
            if (sendFailed) {
                interaction.remove();
            }
        }
        return interaction;
    }

    public TraceResult traceroute(RoxAddress destination) throws TraceFailed, HostNotFound {
        this.checkAddressExistence(destination);
        TraceResult returnValue = new TraceResult(destination);
        PingResult tmpResult = null;
        Interaction interaction = null;
        try {
            for (byte ttl = 1; ttl < 10; ttl = (byte)(ttl + 1)) {
                interaction = this.doPing(destination, ttl);
                interaction.waitForResponse();
                tmpResult = interaction.getResult();
                if (tmpResult.failureCode() != 6) {
                    if (tmpResult.isSuccess()) {
                        returnValue.addHop(tmpResult);
                        returnValue.setSuccess(true);
                        return returnValue;
                    }
                    returnValue.addHop(tmpResult);
                    returnValue.setSuccess(false);
                    return returnValue;
                }
                returnValue.addHop(tmpResult);
            }
        }
        catch (TransportException te) {
            throw new TraceFailed(NetMessageCode.TRNS_TRACEROUTE_FAILED, returnValue, te, new String[]{destination.toString()});
        }
        returnValue.setSuccess(false);
        throw new TraceFailed(NetMessageCode.TRNS_CONTROL_TTL_EXPIRED, returnValue, new String[]{destination.toString(), String.valueOf(10)});
    }

    private synchronized short allocateInteractionId() {
        if (this.interactionCounter >= Short.MAX_VALUE) {
            this.interactionCounter = 1;
        }
        short s = this.interactionCounter;
        this.interactionCounter = (short)(s + 1);
        return s;
    }

    private void checkAddressExistence(RoxAddress addr) throws HostNotFound {
        try {
            if (!this.tManager.isLocal(addr)) {
                this.tManager.getRouteTable().getNextHop(addr);
            }
        }
        catch (NoRouteToHost e) {
            throw new HostNotFound(NetMessageCode.TRNS_HOST_ROUTE_NOT_FOUND, (Throwable)e, new String[]{addr.toString()});
        }
    }

    private String getExceptionMessage(Throwable t) {
        StringBuffer sb = new StringBuffer();
        do {
            sb.append(t.getMessage());
        } while (t instanceof RaplixException && (t = ((RaplixException)t).nestedException()) != null);
        return sb.toString();
    }

    private class Interaction {
        short id;
        boolean notified = false;
        private PingResult pr = null;
        private long timeStamp;

        Interaction(short id) {
            this.id = id;
            this.timeStamp = System.currentTimeMillis();
        }

        synchronized void waitForResponse() throws TimedOut {
            try {
                if (!this.notified) {
                    this.wait(TransportControl.this.INTERACTION_TIMEOUT);
                }
            }
            catch (InterruptedException i) {
                throw new TimedOut(NetMessageCode.TRNS_CONTROL_WAIT_INTERRUPTED, (Throwable)i);
            }
            finally {
                this.remove();
            }
            if (!this.notified) {
                throw new TimedOut(NetMessageCode.TRNS_CONTROL_WAIT_TIMED_OUT, (Object[])new String[]{String.valueOf(TransportControl.this.INTERACTION_TIMEOUT)});
            }
        }

        synchronized void notifyWaiter(PingResult pr) {
            this.pr = pr;
            pr.setTimeTaken(System.currentTimeMillis() - this.timeStamp);
            this.notified = true;
            this.notify();
            this.remove();
        }

        long getStartTimeStamp() {
            return this.timeStamp;
        }

        short getId() {
            return this.id;
        }

        void remove() {
            TransportControl.this.interactions.remove(new Short(this.id));
        }

        PingResult getResult() {
            return this.pr;
        }

        public String toString() {
            return this.getClass().getName() + ":id:" + this.id + ":timeStamp:" + this.timeStamp + ":notified:" + this.notified + ":result:" + this.pr;
        }
    }
}

