/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import java.util.Enumeration;
import java.util.Vector;

public final class TraceResult
implements RPCSerializable {
    private RoxAddress destId;
    private boolean success;
    private Vector pingResults;

    TraceResult(RoxAddress destinationId) {
        this.destId = destinationId;
        this.pingResults = new Vector();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Enumeration hops() {
        return this.pingResults.elements();
    }

    public PingResult[] getHops() {
        return (PingResult[])this.pingResults.toArray();
    }

    void addHop(PingResult pr) {
        this.pingResults.add(pr);
    }

    void setSuccess(boolean val) {
        this.success = val;
        this.fixTTLFailures();
    }

    private void fixTTLFailures() {
        int max = this.pingResults.size() - 1;
        for (int i = 0; i < max; ++i) {
            PingResult pr = (PingResult)this.pingResults.elementAt(i);
            pr.hideTTLFailure();
        }
    }

    public RoxAddress getDestinationId() {
        return this.destId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(":dest:").append(this.destId).append(this.success ? ":success:" : ":failed:");
        sb.append(":pings:\n");
        Enumeration e = this.pingResults.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement()).append("\n");
        }
        return sb.toString();
    }

    private TraceResult() {
    }
}

