/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.HandshakeConductor;
import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.RouteTable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.ServerHandshakeConductor;
import com.raplix.rolloutexpress.net.transport.TransportControl;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.util.logger.Logger;
import java.io.InputStream;
import java.io.OutputStream;

public class StdIOConnectionManager
extends ConnectionEventListener {
    private RouteTable routeTable;
    public static int CHECK_MAIN_CONN_FREQ = 1;

    public StdIOConnectionManager(ConnectionManager cMgr, RouteTable rTable, InputStream is, OutputStream os, RoxAddress local, RoxAddress remote, NetSubsystem nss) throws TransportException {
        super(cMgr);
        this.routeTable = rTable;
        Connection conn = new Connection(this, is, os, local, remote, TransportInfo.SERVER_SIDE, ConnectionSetupAttribute.TYPE_SSH);
        conn.postCreate();
    }

    public void createdConnection(Connection c) throws TransportException {
        this.cManager.addConnection(c);
        this.cManager.addLocalEndpoint(c.getLocalId());
        this.cManager.setClientLocalEndpointAddress(c.getLocalId());
        this.routeTable.setDefaultRoute(c.getRemoteId());
    }

    public void releaseConnection(Connection c) {
        this.cManager.releaseConnection(c);
        this.cManager.removeLocalEndpoint(c.getLocalId());
        this.routeTable.setDefaultRoute(null);
        this.cManager.closedIOConnection();
    }

    HandshakeConductor getHandshaker() {
        return new ServerHandshakeConductor(this.cManager.getTransportManager(), this.cManager.getTransportManager().getNetSubsystem().getApplication().getRoxVersionNumber());
    }

    private class CheckMainConnection
    implements Runnable {
        private RoxAddress remoteAddress;
        private TransportControl tControl;

        CheckMainConnection(TransportControl tControl, RoxAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            this.tControl = tControl;
        }

        public void run() {
            block4: {
                try {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Pinging main connection remote endpoint:" + this.remoteAddress, this);
                    }
                    PingResult pr = this.tControl.ping(this.remoteAddress);
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Pinged main connection remote endpoint:" + pr, this);
                    }
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) break block4;
                    Logger.error("Error pinging the main connection remote endpoint", e, this);
                }
            }
        }
    }
}

