/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.PacketHandler;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportMessage;

class SshProxyPacketHandler
implements PacketHandler {
    private RoxAddress msAddress;
    private RoxAddress pcAddress;
    private RoxAddress clAddress;
    private ConnectionManager cMgr;

    public SshProxyPacketHandler(RoxAddress inMSAddress, RoxAddress inPCAddress, RoxAddress inCLAddress, ConnectionManager cMgr) {
        this.msAddress = inMSAddress;
        this.pcAddress = inPCAddress;
        this.clAddress = inCLAddress;
        this.cMgr = cMgr;
    }

    public boolean handlePacket(TransportMessage msg, Connection conn) throws TransportException {
        if (msg.getSourceId().equals(this.msAddress)) {
            msg.setDestinationId(this.clAddress);
            msg.setSourceId(this.pcAddress);
            Connection c = this.cMgr.getConnectionTo(this.clAddress);
            c.send(msg);
            return true;
        }
        if (msg.getSourceId().equals(this.clAddress)) {
            msg.setDestinationId(this.msAddress);
            Connection c = this.cMgr.getConnectionTo(this.msAddress);
            msg.setSourceId(c.getLocalId());
            c.send(msg);
            return true;
        }
        return false;
    }
}

