/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;

class SshConnection
extends Connection {
    private Process sshProcess;
    private SshErrorReader errorReader;
    public static final String LOG_TAG = "SSH.STDERR";
    private static final int MAX_STDERR_LINES = 20;
    private static final int MAX_STDERR_LINE_LEN = 200;

    public SshConnection(ConnectionEventListener cListener, RoxAddress local, RoxAddress remote, TransportInfo info, String connType, Process sshProcess) throws TransportException {
        super(cListener, sshProcess.getInputStream(), sshProcess.getOutputStream(), local, remote, info, connType);
        this.sshProcess = sshProcess;
        this.errorReader = new SshErrorReader(this, sshProcess.getErrorStream());
        cListener.registerThreadForStart(this.errorReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void releaseConnection() {
        try {
            super.releaseConnection();
            this.errorReader.close();
        }
        finally {
            this.sshProcess.destroy();
        }
    }

    public String getAdditionalFailureInfo() {
        return this.errorReader.getStdErrOutput();
    }

    private static class SshErrorReader
    extends SafeThread {
        private BufferedReader reader;
        private boolean isClosed = false;
        private LinkedList mStdErrLines = new LinkedList();

        SshErrorReader(Connection c, InputStream is) {
            super(c.toString() + ":ErrorReader");
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        void close() {
            block2: {
                try {
                    this.isClosed = true;
                    this.interruptSafe();
                    this.reader.close();
                }
                catch (IOException ioe) {
                    if (!Logger.isDebugEnabled(this)) break block2;
                    Logger.debug("Error closing:" + this, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                try {
                    String str;
                    while ((str = this.reader.readLine()) != null) {
                        LinkedList linkedList = this.mStdErrLines;
                        synchronized (linkedList) {
                            this.mStdErrLines.addLast(str.length() > 200 ? str.substring(0, 200) : str);
                            while (this.mStdErrLines.size() > 20) {
                                this.mStdErrLines.removeFirst();
                            }
                        }
                        if (!Logger.isWarnEnabled(SshConnection.LOG_TAG)) continue;
                        Logger.warn(str, SshConnection.LOG_TAG);
                    }
                }
                catch (IOException ie) {
                    if (this.isClosed) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Exception when reading ssh error stream", ie, this);
                        }
                    }
                    if (!Logger.isErrorEnabled(this)) break block9;
                    Logger.error("Exception when reading ssh error stream", ie, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getStdErrOutput() {
            LinkedList linkedList = this.mStdErrLines;
            synchronized (linkedList) {
                return this.mStdErrLines.toString();
            }
        }
    }
}

