/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.ClientConnectionSetupHandler;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SshClientPortAllocator;
import com.raplix.rolloutexpress.net.transport.SshConnection;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.node.bootstrap.BootStrap;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SshClientConnectionHandler
extends ClientConnectionSetupHandler {
    private final String SSH;
    private final String SSH_ARGS;
    private final String JAVA_ARGS;
    private final String APP_ARGS;
    private final String JAVA;
    private final String CLASSPATH;
    private final String CLASSPATH_PREFIX;
    private final String TEST_MAIN_CLASS;
    private final String RA_MAIN_CLASS;
    private final String LD_MAIN_CLASS;
    private final String PROXY_MAIN_CLASS;
    private static final String classpathOption = "-classpath";
    private static final String propertyOption = "-D";
    private NetSubsystem netSubsystem;
    private SshClientPortAllocator portAllocator;
    public static final String PARAM_APPTYPE = "appType";
    public static final String APPTYPE_TEST = "test";
    public static final String APPTYPE_RA = "ra";
    public static final String APPTYPE_LD = "ld";
    public static final String APPTYPE_PROXY = "proxy";
    public static final String PARAM_SSH = "sshpath";
    public static final String PARAM_SSH_ARGS = "sshargs";
    public static final String PARAM_JAVA = "javapath";
    public static final String PARAM_APPCLASS = "classname";
    public static final String PARAM_CLASSPATH = "classpath";
    public static final String PARAM_CLASSPATH_PREFIX = "cprefix";
    public static final String PARAM_JVM_ARGS = "jvmargs";
    public static final String PARAM_APP_ARGS = "appargs";
    public static final String PARAM_SEPARATOR = ",";
    public static final String PARAM_KEY_VALUE_SEPARATOR = "=";
    public static final String PARAM_ARG_SEPARATOR = "|";
    public static final String FILE_SEPARATOR = "/";
    public static final String PATH_SEPARATOR = ":";
    public static final String AGENT_JVM_WRAPPER_PATH = "bin/protect/jexec";
    public static final String PROXY_JVM_WRAPPER_PATH = "bin/.jvm";
    public static final String BOOTSTRAP_CLASS_NAME = BootStrap.class.getName();
    public static final String INSTALLED_COMMON_JVM_PATH = "../common/jre/bin/java";
    public static final String INSTALLED_APP_JVM_PATH = "jvm/jre/bin/java";
    public static final String BORNE_SHELL = "/bin/sh";
    public static final String BORNE_SHELL_CMD_OPTION = "-c";

    public SshClientConnectionHandler(NetSubsystem nss) throws ConfigurationException {
        this.SSH = nss.getSSHPath();
        this.JAVA = nss.getJavaPath();
        this.TEST_MAIN_CLASS = nss.getRemoteAppTestMainClass();
        this.RA_MAIN_CLASS = nss.getRemoteAppRaMainClass();
        this.LD_MAIN_CLASS = nss.getRemoteAppLdMainClass();
        this.PROXY_MAIN_CLASS = nss.getRemoteAppProxyMainClass();
        this.CLASSPATH = nss.getRemoteAppClasspath();
        this.SSH_ARGS = nss.getSSHArgs();
        this.JAVA_ARGS = nss.getJavaArgs();
        this.APP_ARGS = nss.getAppArgs();
        this.CLASSPATH_PREFIX = nss.getRemoteAppClasspathPrefix();
        this.netSubsystem = nss;
        try {
            this.portAllocator = (SshClientPortAllocator)Class.forName(nss.getSshClientPortAllocator()).newInstance();
            this.portAllocator.initAllocator(nss);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Instantiated port allocator:" + this.portAllocator, this);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("net.transport.ssh_port_allocator_not_found", (Throwable)cnfe, new String[]{nss.getSshClientPortAllocator()});
        }
        catch (IllegalAccessException iae) {
            throw new ConfigurationException("net.transport.ssh_port_allocator_not_found", (Throwable)iae, new String[]{nss.getSshClientPortAllocator()});
        }
        catch (InstantiationException ie) {
            throw new ConfigurationException("net.transport.ssh_port_allocator_not_found", (Throwable)ie, new String[]{nss.getSshClientPortAllocator()});
        }
    }

    public Connection setupConnection(ConnectionEventListener c, ConnectionSetupAttribute csa, RoxAddress destination, String runtimeParameters) throws TransportException {
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Setting up connTo:" + csa, this);
            }
            RoxAddress localAddress = this.allocateLocalEndpoint();
            String parms = csa.getParameters();
            String javaRuntime = this.JAVA;
            String ssh = this.SSH;
            String classpath = this.CLASSPATH;
            String mainClass = null;
            String appType = APPTYPE_TEST;
            String appArgs = this.APP_ARGS;
            String sshArgs = this.SSH_ARGS;
            String classpathPrefix = this.CLASSPATH_PREFIX;
            String jvmArgs = this.JAVA_ARGS;
            if (parms != null & parms.trim().length() > 0) {
                StringTokenizer strTok = new StringTokenizer(parms, PARAM_SEPARATOR);
                while (strTok.hasMoreTokens()) {
                    String token = strTok.nextToken();
                    int idx = token.indexOf(PARAM_KEY_VALUE_SEPARATOR);
                    String value = idx > 0 ? token.substring(++idx) : null;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("parm:" + token, this);
                    }
                    if (token.startsWith(PARAM_APPCLASS)) {
                        if (value == null) continue;
                        mainClass = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_CLASSPATH)) {
                        if (value == null) continue;
                        classpath = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_JAVA)) {
                        if (value == null) continue;
                        javaRuntime = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_SSH)) {
                        if (value == null) continue;
                        ssh = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_APPTYPE)) {
                        if (value == null) continue;
                        appType = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_JVM_ARGS)) {
                        jvmArgs = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_SSH_ARGS)) {
                        sshArgs = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_CLASSPATH_PREFIX)) {
                        classpathPrefix = value;
                        continue;
                    }
                    if (token.startsWith(PARAM_APP_ARGS)) {
                        appArgs = value;
                        if (!Logger.isDebugEnabled(this)) continue;
                        Logger.debug("AppArgs:" + appArgs, this);
                        continue;
                    }
                    if (!Logger.isWarnEnabled(this)) continue;
                    Logger.warn("Ignoring unknown parameter:" + token, this);
                }
            }
            if (classpathPrefix == this.CLASSPATH_PREFIX) {
                throw new TransportException(NetMessageCode.TRNS_SSH_CPREFIX_NOT_SPECIFIED, (Object[])new String[]{destination.toString()});
            }
            String bootstrapClass = null;
            UnixCommand ldUnixCommand = null;
            jvmArgs = jvmArgs + "|-Drox_home_dir=" + classpathPrefix;
            if (appType.equals(APPTYPE_TEST)) {
                if (mainClass == null) {
                    mainClass = this.TEST_MAIN_CLASS;
                }
            } else if (appType.equals(APPTYPE_RA)) {
                bootstrapClass = this.RA_MAIN_CLASS;
                if (javaRuntime == this.JAVA) {
                    javaRuntime = classpathPrefix + FILE_SEPARATOR + AGENT_JVM_WRAPPER_PATH;
                }
            } else if (appType.equals(APPTYPE_LD)) {
                bootstrapClass = this.LD_MAIN_CLASS;
                if (javaRuntime == this.JAVA) {
                    javaRuntime = classpathPrefix + FILE_SEPARATOR + INSTALLED_APP_JVM_PATH;
                    ldUnixCommand = new UnixCommand();
                }
            } else if (appType.equals(APPTYPE_PROXY)) {
                bootstrapClass = this.PROXY_MAIN_CLASS;
                if (javaRuntime == this.JAVA) {
                    javaRuntime = classpathPrefix + FILE_SEPARATOR + PROXY_JVM_WRAPPER_PATH;
                }
            } else {
                new TransportException(NetMessageCode.TRNS_SSH_INVALID_APP_TYPE, (Object[])new String[]{appType, destination.toString()});
            }
            if (bootstrapClass != null) {
                mainClass = BOOTSTRAP_CLASS_NAME;
            }
            DefaultCommand cmdLine = new DefaultCommand();
            cmdLine.addParameter(ssh);
            if (sshArgs != null && sshArgs.trim().length() > 0) {
                Vector args = SshClientConnectionHandler.parseArgs(sshArgs);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Adding sshArgs:" + args, this);
                }
                cmdLine.addParameters(args);
            }
            cmdLine.addParameter(csa.getAddress());
            if (ldUnixCommand != null) {
                cmdLine.addParameter(BORNE_SHELL);
                cmdLine.addParameter(BORNE_SHELL_CMD_OPTION);
                SshClientConnectionHandler.addSelectJvm(ldUnixCommand, classpathPrefix);
                this.constructRemoteCommand(ldUnixCommand, jvmArgs, classpathPrefix, classpath, mainClass, bootstrapClass, destination, localAddress, appArgs);
                cmdLine.addParameter(ldUnixCommand.getCommandLine());
            } else {
                cmdLine.addParameter(javaRuntime);
                this.constructRemoteCommand(cmdLine, jvmArgs, classpathPrefix, classpath, mainClass, bootstrapClass, destination, localAddress, appArgs);
            }
            String[] command = cmdLine.getCommandLine();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < command.length; ++i) {
                sb.append(command[i]).append(" ");
            }
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Executing:" + sb, this);
            }
            Process p = Runtime.getRuntime().exec(command);
            SshConnection conn = new SshConnection(c, localAddress, destination, TransportInfo.CLIENT_SIDE, csa.getType(), p);
            conn.postCreate();
            return conn;
        }
        catch (IOException ioe) {
            throw new TransportException(NetMessageCode.TRNS_SSH_CANNOT_FORK, (Throwable)ioe, (Object[])new String[]{destination.toString()});
        }
    }

    public static void addSelectJvm(UnixCommand inLdUnixCommand, String inClassPathPrefix) {
        String appJvm = inClassPathPrefix + FILE_SEPARATOR + INSTALLED_APP_JVM_PATH;
        String commonJvm = inClassPathPrefix + FILE_SEPARATOR + INSTALLED_COMMON_JVM_PATH;
        inLdUnixCommand.addText("if [ -x ");
        inLdUnixCommand.addParameter(appJvm);
        inLdUnixCommand.addText(" ]; then _sps_jvm=");
        inLdUnixCommand.addParameter(appJvm);
        inLdUnixCommand.addText("; else _sps_jvm=");
        inLdUnixCommand.addParameter(commonJvm);
        inLdUnixCommand.addText("; fi; exec ");
        inLdUnixCommand.addParameter("\\$_sps_jvm", false);
    }

    private void constructRemoteCommand(Command inCmdLine, String inJvmArgs, String inClasspathPrefix, String inClasspath, String inMainClass, String inBootstrapClass, RoxAddress destination, RoxAddress inLocalAddress, String inAppArgs) {
        Vector args;
        if (inJvmArgs != null && inJvmArgs.trim().length() > 0) {
            args = SshClientConnectionHandler.parseArgs(inJvmArgs);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Adding jvmArgs:" + args, this);
            }
            inCmdLine.addParameters(args);
        }
        inCmdLine.addParameter(classpathOption);
        if (inClasspathPrefix != null) {
            inCmdLine.addParameter(this.addClasspathPrefix(inClasspathPrefix, inClasspath));
        } else {
            inCmdLine.addParameter(inClasspath);
        }
        inCmdLine.addParameter(inMainClass);
        if (inBootstrapClass != null) {
            if (Logger.isWarnEnabled("SSH.STDERR")) {
                inCmdLine.addParameter("-verbose");
            }
            inCmdLine.addParameter(inBootstrapClass);
        }
        inCmdLine.addParameter("-Dnet.local.ip=" + destination.ipString());
        inCmdLine.addParameter("-Dnet.local.port=" + destination.getPort());
        inCmdLine.addParameter("-Dnet.remote.ip=" + inLocalAddress.ipString());
        inCmdLine.addParameter("-Dnet.remote.port=" + inLocalAddress.getPort());
        if (inAppArgs != null && inAppArgs.trim().length() > 0) {
            args = SshClientConnectionHandler.parseArgs(inAppArgs);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Adding appArg:" + args, this);
            }
            inCmdLine.addParameters(args);
        }
    }

    static Vector parseArgs(String str) {
        Vector<String> vec = new Vector<String>();
        StringTokenizer strTok = new StringTokenizer(str, PARAM_ARG_SEPARATOR);
        while (strTok.hasMoreTokens()) {
            String value = strTok.nextToken();
            if (value == null || value.trim().length() <= 0) continue;
            vec.add(value);
        }
        return vec;
    }

    public String getHandledType() {
        return ConnectionSetupAttribute.TYPE_SSH;
    }

    public Connection setupConnection(ConnectionEventListener c, ConnectionSetupAttribute csa, RoxAddress destination) throws TransportException {
        return this.setupConnection(c, csa, destination, null);
    }

    private RoxAddress allocateLocalEndpoint() throws TransportException {
        RoxAddress address = this.netSubsystem.getTransport().getNodeAddress();
        if (RoxAddress.local.equals(address)) {
            return RoxAddress.getLocalHostAt(this.portAllocator.getPort());
        }
        return new RoxAddress(address.getIPAddress(), this.portAllocator.getPort());
    }

    private String addClasspathPrefix(String classpathPrefix, String classpath) {
        StringBuffer sb = new StringBuffer();
        if (!classpathPrefix.endsWith(FILE_SEPARATOR)) {
            classpathPrefix = classpathPrefix + FILE_SEPARATOR;
        }
        StringTokenizer strTok = new StringTokenizer(classpath, PATH_SEPARATOR);
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            File path = new File(token);
            if (path.isAbsolute()) {
                sb.append(token);
            } else {
                sb.append(classpathPrefix).append(token);
            }
            if (!strTok.hasMoreTokens()) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }

    public static class UnixCommand
    extends Command {
        private StringBuffer mBuffer = new StringBuffer("\"");

        public void addParameter(String parm) {
            this.addParameter(parm, true);
        }

        public void addParameter(String parm, boolean escape) {
            this.mBuffer.append("\\\"");
            if (escape) {
                this.escapeAndAdd(parm, this.mBuffer);
            } else {
                this.mBuffer.append(parm);
            }
            this.mBuffer.append("\\\" ");
        }

        public void addText(String text) {
            this.mBuffer.append(text);
        }

        public String getCommandLine() {
            return this.mBuffer.toString() + "\"";
        }

        private void escapeAndAdd(String inParm, StringBuffer inBuffer) {
            block3: for (int i = 0; i < inParm.length(); ++i) {
                char c = inParm.charAt(i);
                switch (c) {
                    case '\"': 
                    case '$': 
                    case '\\': 
                    case '`': {
                        inBuffer.append("\\\\\\");
                        inBuffer.append(c);
                        continue block3;
                    }
                    default: {
                        inBuffer.append(c);
                    }
                }
            }
        }
    }

    public static class DefaultCommand
    extends Command {
        private LinkedList mCmd = new LinkedList();

        public void addParameter(String parm) {
            this.mCmd.add(parm);
        }

        public String[] getCommandLine() {
            return this.mCmd.toArray(new String[this.mCmd.size()]);
        }
    }

    public static abstract class Command {
        public abstract void addParameter(String var1);

        public void addParameters(List parameters) {
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.addParameter(s);
            }
        }
    }
}

