/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionServer;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.ServerConnectionSetupHandler;
import com.raplix.rolloutexpress.net.transport.SocketConnectionServer;
import com.raplix.rolloutexpress.net.transport.TransportException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

abstract class SocketServerConnectionHandler
extends ServerConnectionSetupHandler {
    SocketServerConnectionHandler() {
    }

    final ConnectionServer startServer(ConnectionSetupAttribute csa, ConnectionEventListener cel, ConnectionManager cMgr) throws TransportException {
        if (!csa.getType().equals(this.getHandledType())) {
            throw new TransportException(NetMessageCode.TRNS_CONN_HANDLER_INVALID_TYPE, (Object[])new String[]{this.getHandledType(), csa.getType()});
        }
        RoxAddress addr = null;
        try {
            addr = new RoxAddress(csa.getAddress(), csa.getPort());
            SocketConnectionServer scs = this.createServer(csa, cel, cMgr, this.createServerSocket(cMgr, csa.getPort(), InetAddress.getByName(csa.getAddress())));
            cel.registerThreadForStart(scs);
            return scs;
        }
        catch (IOException ioe) {
            throw new TransportException(NetMessageCode.TRNS_SERVER_SOCKET_ERROR, (Throwable)ioe, (Object[])new String[]{addr.toString()});
        }
    }

    protected SocketConnectionServer createServer(ConnectionSetupAttribute csAttrib, ConnectionEventListener cListener, ConnectionManager cMgr, ServerSocket inServer) throws TransportException {
        return new SocketConnectionServer(csAttrib, cListener, cMgr, inServer);
    }

    abstract ServerSocket createServerSocket(ConnectionManager var1, int var2, InetAddress var3) throws IOException, TransportException;
}

