/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionServer;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SocketConnection;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLException;

class SocketConnectionServer
extends SafeThread
implements ConnectionServer {
    private ServerSocket serverSocket;
    private RoxAddress localAddress;
    private ConnectionSetupAttribute mSetupAttrib;
    private ConnectionEventListener cListener;
    protected final ConnectionManager cManager;
    private boolean shutdownInitiated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Socket socket = null;
            SocketConnection connection = null;
            this.cManager.addLocalEndpoint(this.localAddress);
            while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Before accept on server connection:" + this.serverSocket, this);
                    }
                    socket = this.accept();
                    if (this.shutdownInitiated) {
                        break;
                    }
                    if (socket == null) continue;
                    connection = new SocketConnection(this.cListener, socket.getInputStream(), socket.getOutputStream(), this.localAddress, new RoxAddress(socket.getInetAddress(), socket.getPort()), TransportInfo.SERVER_SIDE, this.mSetupAttrib.getType(), socket);
                    connection.postCreate();
                }
                catch (SecurityException se) {
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error("Security Exception when accepting connection", se, this);
                }
                catch (TransportException te) {
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error("Transport Exception when accepting connection:sock:" + socket, te, this);
                }
                catch (SSLException e) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("SSL Exception when accepting connection:sock:" + socket, e, this);
                    }
                    throw e;
                }
                catch (IOException e) {
                    if (this.shutdownInitiated) {
                        if (!Logger.isDebugEnabled(this)) continue;
                        Logger.debug("Shutting down socket:Exception when accepting socket connection", e, this);
                        continue;
                    }
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error("Exception when accepting socket connection", e, this);
                }
            }
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unexpected Exception when accepting socket connection", e, this);
            }
        }
        finally {
            this.cManager.removeLocalEndpoint(this.localAddress);
            this.closeServer();
        }
    }

    protected SocketConnectionServer(ConnectionSetupAttribute csa, ConnectionEventListener cel, ConnectionManager cMgr, ServerSocket inServerSocket) throws TransportException {
        super(csa.getType() + "Accept-Thread:" + csa.getPort());
        this.cListener = cel;
        this.cManager = cMgr;
        this.localAddress = new RoxAddress(csa.getAddress(), csa.getPort());
        this.serverSocket = inServerSocket;
        this.mSetupAttrib = csa;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Created server:" + this.serverSocket, this);
        }
    }

    public void shutdown() {
        this.shutdownInitiated = true;
        if (Logger.isInfoEnabled(this)) {
            Logger.info("Shutting down server:", this);
        }
        this.interruptSafe();
        this.closeServer();
    }

    protected Socket accept() throws IOException, TransportException {
        return this.serverSocket.accept();
    }

    private synchronized void closeServer() {
        if (this.serverSocket != null) {
            block4: {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioe) {
                    if (!Logger.isWarnEnabled(this)) break block4;
                    Logger.warn("Error closing server socket:", ioe, this);
                }
            }
            this.serverSocket = null;
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("Server Socket closed:" + this.serverSocket, this);
            }
        }
    }
}

