/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Uninterruptible;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketConnection
extends Connection {
    private CloseSocket mCloseSocket;

    SocketConnection(ConnectionEventListener cListener, InputStream is, OutputStream os, RoxAddress local, RoxAddress remote, TransportInfo info, String connType, Socket socket) throws TransportException {
        super(cListener, is, os, local, remote, info, connType);
        this.mCloseSocket = new CloseSocket(socket);
    }

    protected synchronized void close() {
        block3: {
            if (this.closed) {
                return;
            }
            super.close();
            try {
                this.mCloseSocket.run();
            }
            catch (Exception ioe) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("Exception when closing socket:" + this, ioe, this);
            }
        }
    }

    private static class CloseSocket
    extends Uninterruptible {
        private Socket mSocket;

        public CloseSocket(Socket inSocket) {
            this.mSocket = inSocket;
        }

        protected Object execute() throws Exception {
            this.mSocket.close();
            return null;
        }
    }
}

