/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.ClientConnectionSetupHandler;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SocketConnection;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

abstract class SocketClientConnectionHandler
extends ClientConnectionSetupHandler {
    SocketClientConnectionHandler() {
    }

    public final Connection setupConnection(ConnectionEventListener c, ConnectionSetupAttribute csa, RoxAddress destination, String runtimeParameters) throws TransportException {
        if (!csa.getType().equals(this.getHandledType())) {
            throw new TransportException(NetMessageCode.TRNS_CONN_HANDLER_INVALID_TYPE, (Object[])new String[]{this.getHandledType(), csa.getType()});
        }
        try {
            Socket s = this.createSocket(c.getConnectionManager(), InetAddress.getByName(csa.getAddress()), csa.getPort());
            SocketConnection conn = new SocketConnection(c, s.getInputStream(), s.getOutputStream(), new RoxAddress(s.getLocalAddress(), s.getLocalPort()), destination, TransportInfo.CLIENT_SIDE, csa.getType(), s);
            conn.postCreate();
            return conn;
        }
        catch (UnknownHostException uhe) {
            throw new TransportException(NetMessageCode.TRNS_CONN_CANNOT_CONNECT, (Throwable)uhe, (Object[])new String[]{destination.toString()});
        }
        catch (IOException ioe) {
            throw new TransportException(NetMessageCode.TRNS_CONN_CANNOT_CONNECT, (Throwable)ioe, (Object[])new String[]{destination.toString()});
        }
    }

    public final Connection setupConnection(ConnectionEventListener c, ConnectionSetupAttribute csa, RoxAddress destination) throws TransportException {
        return this.setupConnection(c, csa, destination, null);
    }

    protected abstract Socket createSocket(ConnectionManager var1, InetAddress var2, int var3) throws IOException, TransportException;
}

