/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.HandshakeConductor;
import com.raplix.rolloutexpress.net.transport.HandshakeData;
import com.raplix.rolloutexpress.net.transport.SetupException;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;

class ServerHandshakeConductor
implements HandshakeConductor {
    private String mVersion;
    private boolean mIsComplete = false;
    private TransportManager mTransport;

    public byte[] handshake(byte[] receivedValue, int iteration) throws TransportException {
        switch (iteration) {
            case 0: {
                return this.mVersion.getBytes();
            }
            case 1: {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(receivedValue));
                    this.setHandshakeData((HandshakeData)ois.readObject());
                }
                catch (IOException e) {
                    throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE, (Throwable)e, new Object[]{new BigInteger(receivedValue).toString(16)});
                }
                catch (ClassNotFoundException e) {
                    throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE, (Throwable)e, new Object[]{new BigInteger(receivedValue).toString(16)});
                }
                this.mIsComplete = true;
                return null;
            }
        }
        return null;
    }

    public ServerHandshakeConductor(TransportManager tMgr, String inVersion) {
        this.mTransport = tMgr;
        this.mVersion = inVersion;
    }

    private void setHandshakeData(HandshakeData inHandshakeData) {
        try {
            this.mTransport.getHostUpdateManager();
        }
        catch (SetupException se) {
            if (inHandshakeData.getMSAddress() != null) {
                this.mTransport.setMSAddress(inHandshakeData.getMSAddress());
            }
            this.mTransport.setCompatibilityMode(inHandshakeData.isCompatibilityMode());
        }
    }

    public boolean isHandshakeComplete() {
        return this.mIsComplete;
    }
}

