/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionServer;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.HandshakeConductor;
import com.raplix.rolloutexpress.net.transport.RawServerConnectionHandler;
import com.raplix.rolloutexpress.net.transport.RouteTable;
import com.raplix.rolloutexpress.net.transport.SSLServerConnectionHandler;
import com.raplix.rolloutexpress.net.transport.ServerConnectionSetupHandler;
import com.raplix.rolloutexpress.net.transport.ServerHandshakeConductor;
import com.raplix.rolloutexpress.net.transport.ShutdownInitiated;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.logger.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ServerConnectionManager
extends ConnectionEventListener {
    private RouteTable routeTable;
    private Connection openConnection = null;
    private boolean shutdownInitiated = false;
    private Vector connectionServers = new Vector();
    private boolean doNotallowMultipleConnections = true;
    private Hashtable connectionHandlers = new Hashtable();

    protected ServerConnectionManager(ConnectionManager cMgr, RouteTable rTbl, boolean doNotAllowMultipleConn) {
        super(cMgr);
        this.routeTable = rTbl;
        this.doNotallowMultipleConnections = doNotAllowMultipleConn;
        this.connectionHandlers.put(ConnectionSetupAttribute.TYPE_RAW, new RawServerConnectionHandler());
        this.connectionHandlers.put(ConnectionSetupAttribute.TYPE_SSL, new SSLServerConnectionHandler());
    }

    void startServer(ConnectionSetupAttribute csa) throws TransportException {
        if (this.shutdownInitiated) {
            throw new ShutdownInitiated();
        }
        ServerConnectionSetupHandler sch = (ServerConnectionSetupHandler)this.connectionHandlers.get(csa.getType());
        if (sch == null) {
            throw new TransportException(NetMessageCode.TRNS_SERVER_CONN_NO_HANDLER, (Object[])new String[]{csa.toString(), csa.getType()});
        }
        this.addConnectionServer(sch.startServer(csa, this, this.cManager));
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Started server:" + csa, this);
        }
    }

    private void addConnectionServer(ConnectionServer cs) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Added server:" + cs, this);
        }
        this.connectionServers.add(cs);
    }

    private void removeConnectionServer(ConnectionServer cs) {
        this.connectionServers.remove(cs);
    }

    void shutdownServers() {
        this.shutdownInitiated = true;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Shutting down:" + this.connectionServers, this);
        }
        Enumeration e = this.connectionServers.elements();
        ConnectionServer cs = null;
        while (e.hasMoreElements()) {
            cs = (ConnectionServer)e.nextElement();
            cs.shutdown();
            this.removeConnectionServer(cs);
        }
    }

    public void createdConnection(Connection c) throws TransportException {
        if (this.openConnection != null && this.doNotallowMultipleConnections) {
            throw new TransportException(NetMessageCode.TRNS_SERVER_DUPLICATE_CONN, (Object[])new String[]{this.openConnection.toString()});
        }
        this.cManager.addConnection(c);
        if (this.doNotallowMultipleConnections) {
            this.routeTable.setDefaultRoute(c.getRemoteId());
        } else {
            this.routeTable.addConnectionRoute(c.getRemoteId(), c.getRemoteId());
        }
        this.openConnection = c;
    }

    public void releaseConnection(Connection c) {
        this.openConnection = null;
        this.cManager.releaseConnection(c);
        if (this.doNotallowMultipleConnections) {
            this.routeTable.setDefaultRoute(null);
        } else {
            this.routeTable.removeConnectionRoute(c.getRemoteId());
        }
    }

    HandshakeConductor getHandshaker() {
        return new ServerHandshakeConductor(this.cManager.getTransportManager(), this.cManager.getTransportManager().getNetSubsystem().getApplication().getRoxVersionNumber());
    }

    public String toString() {
        return this.getClass().getName() + ":ConnHandlers:" + this.connectionHandlers;
    }
}

