/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.string.PasswordEscape;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class SSLFactory {
    private static final String SUN_PROVIDER_NAME = "com.sun.net.ssl.internal.ssl.Provider";
    private static final String IBM_PROVIDER_NAME = "com.ibm.jsse.IBMJSSEProvider";
    private SSLContext mContext;
    private boolean mIsClientAuth;
    private String[] mCipherSuites;
    private static boolean providerAdded = false;
    private KeyStore mTrustStore = null;
    private static final String MODE_CARRIER = "OU=";
    private static final String UPSTREAM_ANNOTATION = "upstream";
    private static final String DOWNSTREAM_ANNOTATION = "downstream";
    private File mPrivateStoreFile;
    private File mTrustStoreFile;
    private KeystoreState mRefreshState;
    private String mEncodedPassword;

    public SSLServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.mContext.getServerSocketFactory().createServerSocket(port);
        this.processSocket(socket);
        return socket;
    }

    public SSLServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.mContext.getServerSocketFactory().createServerSocket(port, backlog);
        this.processSocket(socket);
        return socket;
    }

    public SSLServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.mContext.getServerSocketFactory().createServerSocket(port, backlog, address);
        this.processSocket(socket);
        return socket;
    }

    public SSLSocket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.mContext.getSocketFactory().createSocket(host, port);
        this.processSocket(socket);
        return socket;
    }

    public SSLSocket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.mContext.getSocketFactory().createSocket(host, port);
        this.processSocket(socket);
        return socket;
    }

    public SSLSocket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.mContext.getSocketFactory().createSocket(address, port, clientAddress, clientPort);
        this.processSocket(socket);
        return socket;
    }

    public SSLSocket createSocket(String address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.mContext.getSocketFactory().createSocket(address, port, clientAddress, clientPort);
        this.processSocket(socket);
        return socket;
    }

    public void verifyCertificateChain(SSLSocket socket, boolean isPeerUpstream) throws TransportException {
        try {
            Certificate[] certs;
            if (socket.getSession() != null && (certs = socket.getSession().getPeerCertificates()) != null) {
                for (int i = 0; i < certs.length; ++i) {
                    ((X509Certificate)certs[i]).checkValidity();
                    if (!this.checkPresenceInTrustStore(certs[i])) {
                        throw new TransportException(NetMessageCode.TRNS_SSL_UNEXPECTED_CERTIFICATE, (Object[])new String[]{socket.getSession().getPeerHost()});
                    }
                    this.checkModeAnnotations(certs[i], socket, isPeerUpstream);
                }
            }
        }
        catch (SSLPeerUnverifiedException ignored) {
        }
        catch (KeyStoreException kse) {
            throw new TransportException(NetMessageCode.TRNS_SSL_INVALID_KEYSTORE, (Throwable)kse, (Object[])new String[]{socket.getSession().getPeerHost()});
        }
        catch (CertificateExpiredException cee) {
            throw new TransportException(NetMessageCode.TRNS_SSL_CERTIFICATE_EXPIRED, (Throwable)cee, (Object[])new String[]{socket.getSession().getPeerHost()});
        }
        catch (CertificateNotYetValidException cnyve) {
            throw new TransportException(NetMessageCode.TRNS_SSL_CERTIFICATE_NOT_YET_VALID, (Throwable)cnyve, (Object[])new String[]{socket.getSession().getPeerHost()});
        }
    }

    public boolean requiresRefresh() {
        return !this.mRefreshState.equals(new KeystoreState(this.mPrivateStoreFile, this.mTrustStoreFile));
    }

    public SSLFactory refresh(NetSubsystem nss) throws TransportException {
        try {
            TrustManager[] trustManagers;
            char[] keystorePass = PasswordEscape.decodePassword(this.mEncodedPassword).toCharArray();
            KeyManager[] keyManagers = SSLFactory.getKeyManagers(nss, this.mPrivateStoreFile, keystorePass);
            KeyStore trustStore = null;
            if (this.mTrustStoreFile.exists()) {
                trustStore = SSLFactory.getTrustStore(this.mTrustStoreFile, nss.getConfigSSLTrustStoreType(), keystorePass);
                trustManagers = SSLFactory.getTrustManagerFactory(nss, trustStore).getTrustManagers();
                if (Logger.isDebugEnabled(SSLFactory.class)) {
                    Logger.debug("trustmgr:init:" + this.mTrustStoreFile.getAbsolutePath(), SSLFactory.class);
                }
            } else {
                trustManagers = new TrustManager[]{};
            }
            SSLContext ctx = SSLContext.getInstance(this.mContext.getProtocol());
            ctx.init(keyManagers, trustManagers, null);
            return new SSLFactory(this, ctx, trustStore);
        }
        catch (IOException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (TransportException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
    }

    private void checkModeAnnotations(Certificate peercert, SSLSocket socket, boolean isPeerUpstream) throws TransportException {
        String subject;
        int idxStart;
        Vector<String> modes = new Vector<String>();
        modes.add(0, UPSTREAM_ANNOTATION);
        modes.add(1, DOWNSTREAM_ANNOTATION);
        if (peercert instanceof X509Certificate && (idxStart = (subject = ((Object)((X509Certificate)peercert).getSubjectDN()).toString()).indexOf(MODE_CARRIER)) > -1) {
            String mode;
            int idxEnd = subject.indexOf(32, idxStart);
            String string = mode = idxEnd > -1 ? subject.substring(idxStart + MODE_CARRIER.length(), idxEnd - 1) : " ";
            if (isPeerUpstream && mode.equalsIgnoreCase(DOWNSTREAM_ANNOTATION)) {
                throw new TransportException(NetMessageCode.TRNS_SSL_UNEXPECTED_CERTIFICATE_INCORRECT_MODE_ANNOTATION, new Object[]{socket.getSession().getPeerHost(), new Double(modes.indexOf(DOWNSTREAM_ANNOTATION)), new Double(modes.indexOf(UPSTREAM_ANNOTATION))});
            }
            if (!isPeerUpstream && mode.equalsIgnoreCase(UPSTREAM_ANNOTATION)) {
                throw new TransportException(NetMessageCode.TRNS_SSL_UNEXPECTED_CERTIFICATE_INCORRECT_MODE_ANNOTATION, new Object[]{socket.getSession().getPeerHost(), new Double(modes.indexOf(UPSTREAM_ANNOTATION)), new Double(modes.indexOf(DOWNSTREAM_ANNOTATION))});
            }
        }
    }

    private boolean checkPresenceInTrustStore(Certificate peercert) throws KeyStoreException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.mTrustStore != null) {
            String alias = this.mTrustStore.getCertificateAlias(peercert);
            Certificate trustStoreCert = null;
            if (alias != null) {
                trustStoreCert = this.mTrustStore.getCertificate(alias);
            }
            if (trustStoreCert != null && trustStoreCert instanceof X509Certificate && peercert instanceof X509Certificate && ((Object)((X509Certificate)trustStoreCert).getSubjectDN()).equals(((X509Certificate)peercert).getSubjectDN())) {
                return true;
            }
        }
        return false;
    }

    private void processSocket(SSLSocket socket) throws IOException {
        if (this.mCipherSuites != null) {
            socket.setEnabledCipherSuites(this.mCipherSuites);
        }
        socket.startHandshake();
    }

    private void processSocket(SSLServerSocket socket) {
        if (this.mCipherSuites != null) {
            socket.setEnabledCipherSuites(this.mCipherSuites);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("ClientAuth:" + this.mIsClientAuth, this);
        }
        socket.setNeedClientAuth(this.mIsClientAuth);
    }

    static SSLFactory init(NetSubsystem nss, boolean doNotPromptForInput) throws TransportException {
        try {
            TrustManager[] trustManagers;
            SSLFactory.initProvider();
            String sslProtocol = nss.getConfigSSLProtocol();
            SSLContext ctx = SSLContext.getInstance(sslProtocol);
            File privateStoreFile = new File(nss.getConfigSSLPrivateStorePath());
            File trustStoreFile = new File(nss.getConfigSSLTrustStorePath());
            String trustStoreType = nss.getConfigSSLTrustStoreType();
            KeyStore trustStore = null;
            char[] keyStorePass = new char[]{};
            String password = null;
            if (privateStoreFile.exists() || trustStoreFile.exists()) {
                block21: {
                    if (!doNotPromptForInput) {
                        try {
                            password = nss.getApplication().promptForInput(new String[]{NetMessageCode.TRNS_ENTER_KEY_PASSWORD.roxMessage().getMessageString()});
                        }
                        catch (IOException ie) {
                            if (!Logger.isWarnEnabled(SSLFactory.class)) break block21;
                            Logger.warn("Error reading password from stdin", ie, SSLFactory.class);
                        }
                    }
                }
                if (StringUtil.isEmpty(password)) {
                    password = nss.getConfigSSLKeyStorePass();
                }
                keyStorePass = StringUtil.isEmpty(password) ? new char[]{} : password.toCharArray();
            }
            KeyManager[] keyManagers = SSLFactory.getKeyManagers(nss, privateStoreFile, keyStorePass);
            if (trustStoreFile.exists()) {
                trustStore = SSLFactory.getTrustStore(trustStoreFile, trustStoreType, keyStorePass);
                trustManagers = SSLFactory.getTrustManagerFactory(nss, trustStore).getTrustManagers();
                if (Logger.isDebugEnabled(SSLFactory.class)) {
                    Logger.debug("trustmgr:init:" + trustStoreFile.getAbsolutePath(), SSLFactory.class);
                }
            } else {
                trustManagers = new TrustManager[]{};
            }
            ctx.init(keyManagers, trustManagers, null);
            boolean clientAuth = nss.getConfigSSLClientAuth();
            String enabledSuites = nss.getConfigSSLCipherSuites();
            String[] cipherSuites = null;
            if (!StringUtil.isEmpty(enabledSuites)) {
                StringTokenizer tok = new StringTokenizer(enabledSuites, ",");
                cipherSuites = new String[tok.countTokens()];
                int i = 0;
                while (tok.hasMoreTokens()) {
                    cipherSuites[i] = tok.nextToken();
                    ++i;
                }
                SSLFactory.verifyCipherSuites(cipherSuites, ctx);
            }
            if (Logger.isDebugEnabled(SSLFactory.class)) {
                Logger.debug("SSLFactory:init:" + ctx, SSLFactory.class);
            }
            return new SSLFactory(ctx, clientAuth, cipherSuites, trustStore, privateStoreFile, trustStoreFile, PasswordEscape.encodePassword(password));
        }
        catch (IOException ioe) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)ioe);
        }
        catch (KeyManagementException kme) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)kme);
        }
        catch (ConfigurationException confe) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)confe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)nsae);
        }
        catch (KeyStoreException ks) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)ks);
        }
        catch (CertificateException ce) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)ce);
        }
        catch (IllegalAccessException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TransportException(NetMessageCode.TRNS_ERR_INIT_KEY_STORES, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore getTrustStore(File trustStoreFile, String trustStoreType, char[] keyStorePass) throws CertificateException, TransportException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream fis = null;
        KeyStore trustStore = null;
        try {
            try {
                trustStore = KeyStore.getInstance(trustStoreType);
                fis = new FileInputStream(trustStoreFile);
                trustStore.load(fis, keyStorePass);
            }
            catch (FileNotFoundException fnfe) {
                throw new TransportException(NetMessageCode.TRNS_ERR_TRUST_KEY_STORE, (Throwable)fnfe, (Object[])new String[]{trustStoreFile.getAbsolutePath()});
            }
            catch (IOException ioe) {
                throw new TransportException(NetMessageCode.TRNS_ERR_TRUST_KEY_STORE, (Throwable)ioe);
            }
            Object var7_5 = null;
            if (fis == null) return trustStore;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fis.close();
        return trustStore;
    }

    private static void initProvider() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (!providerAdded) {
            Security.addProvider((Provider)Class.forName(PlatformUtil.isAix() ? IBM_PROVIDER_NAME : SUN_PROVIDER_NAME).newInstance());
            providerAdded = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyManager[] getKeyManagers(NetSubsystem nss, File keyFile, char[] password) throws IOException, ConfigurationException, NoSuchAlgorithmException, KeyStoreException, CertificateException, TransportException {
        KeyManager[] keyManagerArray;
        if (!keyFile.exists()) {
            return new KeyManager[0];
        }
        FileInputStream fis = null;
        String keyMgrAlg = nss.getConfigSSLPrivateMgrAlg();
        String keyStoreType = nss.getConfigSSLPrivateStoreType();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyMgrAlg);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        try {
            try {
                fis = new FileInputStream(keyFile);
                ks.load(fis, password);
                if (nss.getConfigSSLInitValidateCerts()) {
                    SSLFactory.verifyKeyStoreCertificates(ks);
                }
                kmf.init(ks, password);
                if (Logger.isDebugEnabled(SSLFactory.class)) {
                    Logger.debug("keymgr:init:" + keyFile.getAbsolutePath(), SSLFactory.class);
                }
                keyManagerArray = kmf.getKeyManagers();
                Object var10_12 = null;
                if (fis == null) return keyManagerArray;
            }
            catch (FileNotFoundException fnfe) {
                throw new TransportException(NetMessageCode.TRNS_ERR_PRIVATE_KEY_STORE, (Throwable)fnfe, new Object[]{keyFile.getAbsolutePath()});
            }
            catch (IOException ioe) {
                throw new TransportException(NetMessageCode.TRNS_ERR_PRIVATE_KEY_STORE, (Throwable)ioe, new Object[]{keyFile.getAbsolutePath()});
            }
            catch (UnrecoverableKeyException uke) {
                throw new TransportException(NetMessageCode.TRNS_ERR_PRIVATE_KEY_STORE, (Throwable)uke, new Object[]{keyFile.getAbsolutePath()});
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ignored) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return keyManagerArray;
        }
        fis.close();
        return keyManagerArray;
    }

    private static TrustManagerFactory getTrustManagerFactory(NetSubsystem nss, KeyStore ks) throws IOException, ConfigurationException, NoSuchAlgorithmException, KeyStoreException, CertificateException, TransportException {
        String trustMgrAlg = nss.getConfigSSLTrustMgrAlg();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustMgrAlg);
        if (nss.getConfigSSLInitValidateCerts()) {
            SSLFactory.verifyKeyStoreCertificates(ks);
        }
        tmf.init(ks);
        return tmf;
    }

    private static void verifyCipherSuites(String[] suites, SSLContext ctx) throws TransportException {
        String[] supportedSuites = ctx.getServerSocketFactory().getSupportedCipherSuites();
        HashSet<String> supportedSet = new HashSet<String>();
        for (int i = 0; i < supportedSuites.length; ++i) {
            supportedSet.add(supportedSuites[i]);
        }
        HashSet<String> unsupportedSet = new HashSet<String>();
        for (int i = 0; i < suites.length; ++i) {
            if (supportedSet.contains(suites[i])) continue;
            unsupportedSet.add(suites[i]);
        }
        if (!unsupportedSet.isEmpty()) {
            throw new TransportException(NetMessageCode.TRNS_ERR_SSL_CIPHER_SUITES, (Object[])new String[]{unsupportedSet.toString(), supportedSet.toString()});
        }
    }

    private SSLFactory(SSLContext inContext, boolean inIsClientAuth, String[] inCipherSuites, KeyStore trustStore, File privateStoreFile, File trustStoreFile, String encodedPassword) {
        this.mContext = inContext;
        this.mIsClientAuth = inIsClientAuth;
        this.mCipherSuites = inCipherSuites;
        this.mTrustStore = trustStore;
        this.mPrivateStoreFile = privateStoreFile;
        this.mTrustStoreFile = trustStoreFile;
        this.mRefreshState = new KeystoreState(this.mPrivateStoreFile, this.mTrustStoreFile);
        this.mEncodedPassword = encodedPassword;
    }

    private SSLFactory(SSLFactory oldFactory, SSLContext inContext, KeyStore inTrustStore) {
        this.mContext = inContext;
        this.mTrustStore = inTrustStore;
        this.mIsClientAuth = oldFactory.mIsClientAuth;
        this.mCipherSuites = oldFactory.mCipherSuites;
        this.mPrivateStoreFile = oldFactory.mPrivateStoreFile;
        this.mTrustStoreFile = oldFactory.mTrustStoreFile;
        this.mRefreshState = new KeystoreState(this.mPrivateStoreFile, this.mTrustStoreFile);
        this.mEncodedPassword = oldFactory.mEncodedPassword;
    }

    private static void verifyKeyStoreCertificates(KeyStore inKeyStore) throws CertificateException, KeyStoreException {
        Enumeration<String> aliases = inKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert;
            String alias = aliases.nextElement();
            Certificate[] certs = inKeyStore.getCertificateChain(alias);
            if (certs != null) {
                for (int i = 0; i < certs.length; ++i) {
                    if (!(certs[i] instanceof X509Certificate)) continue;
                    ((X509Certificate)certs[i]).checkValidity();
                }
            }
            if ((cert = inKeyStore.getCertificate(alias)) == null || !(cert instanceof X509Certificate)) continue;
            ((X509Certificate)cert).checkValidity();
        }
    }

    private static void logKeyStore(KeyStore ks, char[] password) {
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!ks.isCertificateEntry(alias) || !Logger.isInfoEnabled(class$com$raplix$rolloutexpress$net$transport$SSLFactory == null ? SSLFactory.class$("com.raplix.rolloutexpress.net.transport.SSLFactory") : class$com$raplix$rolloutexpress$net$transport$SSLFactory)) continue;
                Logger.info("Alias:" + alias + ":Cert:" + ks.getCertificate(alias), class$com$raplix$rolloutexpress$net$transport$SSLFactory == null ? SSLFactory.class$("com.raplix.rolloutexpress.net.transport.SSLFactory") : class$com$raplix$rolloutexpress$net$transport$SSLFactory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class KeystoreState {
        private long mPrivateStoreTS = -1L;
        private long mPrivateStoreSize = -1L;
        private long mTrustStoreTS = -1L;
        private long mTrustStoreSize = -1L;

        KeystoreState(File privateStoreFile, File trustStoreFile) {
            if (privateStoreFile.exists()) {
                this.mPrivateStoreTS = privateStoreFile.lastModified();
                this.mPrivateStoreSize = privateStoreFile.length();
            }
            if (trustStoreFile.exists()) {
                this.mTrustStoreTS = trustStoreFile.lastModified();
                this.mTrustStoreSize = trustStoreFile.length();
            }
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof KeystoreState) {
                KeystoreState keystoreState = (KeystoreState)o;
                return this.mPrivateStoreSize == keystoreState.mPrivateStoreSize && this.mPrivateStoreTS == keystoreState.mPrivateStoreTS && this.mTrustStoreSize == keystoreState.mTrustStoreSize && this.mTrustStoreTS == keystoreState.mTrustStoreTS;
            }
            return false;
        }
    }
}

