/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.string.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class RoxAddress
implements RPCSerializable {
    public static final RoxAddress local = new RoxAddress(0, 0);
    private int ipAddress;
    private int port;

    private RoxAddress() {
    }

    public RoxAddress(int ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public RoxAddress(InetAddress host, int port) {
        this.ipAddress = RoxAddress.getIPFromBytes(host.getAddress());
        this.port = port;
    }

    public static RoxAddress getLocalHostAt(int localPort) throws TransportException {
        try {
            RoxAddress roxAddr = new RoxAddress(InetAddress.getLocalHost().getHostAddress(), localPort);
            return roxAddr;
        }
        catch (UnknownHostException e) {
            throw new TransportException(NetMessageCode.TRNS_LOCALHOST_ADDR_ERROR, (Throwable)e);
        }
    }

    public RoxAddress(String ip, int port) throws TransportException {
        try {
            if (StringUtil.isEmpty(ip)) {
                throw new TransportException(NetMessageCode.TRNS_ADDR_HOST_NOT_FOUND, (Object[])new String[]{ip});
            }
            this.ipAddress = RoxAddress.getIPFromBytes(InetAddress.getByName(ip).getAddress());
            this.port = port;
        }
        catch (UnknownHostException uhe) {
            throw new TransportException(NetMessageCode.TRNS_ADDR_HOST_NOT_FOUND, (Throwable)uhe, new String[]{ip}, 0);
        }
    }

    private static int getIPFromBytes(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    RoxAddress(byte[] b) {
        this.ipAddress = RoxAddress.getIPFromBytes(b);
        this.port = (b[4] & 0xFF) << 16 | (b[5] & 0xFF) << 8 | b[6] & 0xFF;
    }

    public boolean equals(Object o) {
        if (o instanceof RoxAddress) {
            RoxAddress ra = (RoxAddress)o;
            return this.ipAddress == ra.ipAddress && this.port == ra.port;
        }
        return false;
    }

    public int getIPAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String ipString() {
        StringBuffer sb = new StringBuffer();
        sb.append(0xFF & this.ipAddress >> 24).append('.');
        sb.append(0xFF & this.ipAddress >> 16).append('.');
        sb.append(0xFF & this.ipAddress >> 8).append('.');
        sb.append(0xFF & this.ipAddress);
        return sb.toString();
    }

    public int hashCode() {
        return this.ipAddress ^ this.port;
    }

    byte[] getBytes() {
        byte[] b = new byte[]{(byte)(0xFF & this.ipAddress >> 24), (byte)(0xFF & this.ipAddress >> 16), (byte)(0xFF & this.ipAddress >> 8), (byte)(0xFF & this.ipAddress), (byte)(0xFF & this.port >> 16), (byte)(0xFF & this.port >> 8), (byte)(0xFF & this.port)};
        return b;
    }

    public String toString() {
        return this.ipString() + ":" + this.port;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: RoxAddress <ip hexadecimal> <port_int>");
            System.exit(1);
        }
        try {
            int port = Integer.parseInt(args[1]);
            RoxAddress ra = new RoxAddress(args[0], port);
            System.out.println("Address:" + ra);
            System.out.println("IPString:" + ra.ipString() + ":ip num:" + ra.getIPAddress());
        }
        catch (TransportException te) {
            te.printStackTrace();
        }
    }
}

