/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.NoRouteToHost;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.logger.Logger;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class RouteTable {
    public static final int PACKET_ROUTE_COUNTER_INIT = 3;
    public static final int PACKET_ROUTE_TIMEOUT_FREQ = 5;
    private static final int ROUTE_TYPE_STATIC = 1;
    private static final int ROUTE_TYPE_CONNECTION = 2;
    private static final int ROUTE_TYPE_PACKET = 3;
    private static final String[] routeTypes = new String[]{"none", "Static", "Connection", "Packet"};
    private Hashtable routes = new Hashtable();
    private RoxAddress defaultRoute = null;
    private Hashtable connectionPacketRoutes = new Hashtable();

    RouteTable() {
    }

    public void addStaticRoute(RoxAddress destination, RoxAddress nextHop) {
        this.routes.put(destination, new RouteEntry(nextHop, 1));
    }

    public void removeStaticRoute(RoxAddress destination) throws TransportException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("remove static route:" + destination, this);
        }
        RouteEntry re = null;
        re = (RouteEntry)this.routes.get(destination);
        if (re == null) {
            throw new TransportException(NetMessageCode.TRNS_STATIC_ROUTE_REMOVE_DEST_UNKNOWN, (Object[])new String[]{destination.toString(), this.toString()});
        }
        if (re.type != 1) {
            throw new TransportException(NetMessageCode.TRNS_STATIC_ROUTE_REMOVE_DIFF_TYPE, (Object[])new String[]{destination.toString(), re.toString(), this.toString()});
        }
        this.routes.remove(destination);
    }

    RoxAddress getNextHop(RoxAddress destination) throws NoRouteToHost {
        RouteEntry hop = (RouteEntry)this.routes.get(destination);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("dest:" + destination + ":hop:" + hop + ":routes:" + this, this);
        }
        if (hop == null) {
            if (this.defaultRoute == null) {
                throw new NoRouteToHost(NetMessageCode.TRNS_NO_ROUTE_FOUND, (Object[])new String[]{destination.toString()});
            }
            return this.defaultRoute;
        }
        return hop.hop;
    }

    void addConnectionRoute(RoxAddress destination, RoxAddress nextHop) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Adding connection route:" + destination + ":next:" + nextHop, this);
        }
        this.routes.put(destination, new RouteEntry(nextHop, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnectionRoute(RoxAddress destination) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("remove connection route:" + destination, this);
        }
        RouteEntry re = null;
        Hashtable hashtable = this.routes;
        synchronized (hashtable) {
            re = (RouteEntry)this.routes.get(destination);
            if (re == null) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("remove connection route for unknown destination" + destination + ":" + this, this);
                }
            } else if (re.type != 2) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("remove connection route for different route type, dest:" + destination + ":route entry:" + re + ":" + this, this);
                }
            } else {
                HashSet packetRouteSet;
                this.routes.remove(destination);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("connectionPacketRoutes:" + this.connectionPacketRoutes, this);
                }
                if ((packetRouteSet = (HashSet)this.connectionPacketRoutes.get(destination)) != null) {
                    Iterator iter = packetRouteSet.iterator();
                    while (iter.hasNext()) {
                        RoxAddress address = (RoxAddress)iter.next();
                        re = (RouteEntry)this.routes.get(address);
                        if (re.type != 3) continue;
                        this.routes.remove(address);
                        if (!Logger.isInfoEnabled(this)) continue;
                        Logger.info("Removing packet route for:" + address, this);
                    }
                    this.connectionPacketRoutes.remove(destination);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPacketRoute(RoxAddress destination, RoxAddress connRemoteAddr) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Adding packet route:" + destination + "," + connRemoteAddr, this);
        }
        RouteEntry re = null;
        Hashtable hashtable = this.routes;
        synchronized (hashtable) {
            re = (RouteEntry)this.routes.get(destination);
            if (re == null) {
                this.routes.put(destination, new RouteEntry(connRemoteAddr, 3));
                HashSet<RoxAddress> packetRouteSet = (HashSet<RoxAddress>)this.connectionPacketRoutes.get(connRemoteAddr);
                if (packetRouteSet == null) {
                    packetRouteSet = new HashSet<RoxAddress>();
                    this.connectionPacketRoutes.put(connRemoteAddr, packetRouteSet);
                }
                packetRouteSet.add(destination);
            }
        }
    }

    void setDefaultRoute(RoxAddress defaultHop) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Set default route to:" + defaultHop, this);
        }
        this.defaultRoute = defaultHop;
    }

    public String toString() {
        return "RouteTable:routes:" + this.routes + ":default:" + this.defaultRoute + "packetRoutes:" + this.connectionPacketRoutes;
    }

    private static class RouteEntry {
        final RoxAddress hop;
        final int type;

        RouteEntry(RoxAddress hop, int type) {
            this.hop = hop;
            this.type = type;
        }

        public String toString() {
            return "RouteEntry:hop:" + this.hop + ":type:" + routeTypes[this.type];
        }
    }
}

