/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.rolloutexpress.net.transport.TransportMessage;

public abstract class ProtocolManager {
    private TransportManager tManager;

    protected ProtocolManager() {
    }

    public abstract byte getProtocolId();

    protected final void sendMessage(TransportMessage msg) throws TransportException {
        msg.setType(this.getProtocolId());
        if (this.tManager == null) {
            throw new TransportException(NetMessageCode.TRNS_PROTOCOL_MGR_UNREGISTERED);
        }
        this.tManager.sendMessage(msg);
    }

    final void registeredProtocol(TransportManager tMgr) {
        this.tManager = tMgr;
    }

    protected final TransportManager getTransport() throws TransportException {
        if (this.tManager == null) {
            throw new TransportException(NetMessageCode.TRNS_PROTOCOL_MGR_UNREGISTERED);
        }
        return this.tManager;
    }

    protected abstract void receiveMessage(TransportMessage var1) throws MessageNotExpected;

    protected abstract void errorDeliveringMessage(TransportMessage var1, ErrorDetails var2);
}

