/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.FailureCodes;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportControlMessage;

public final class PingResult
implements RPCSerializable,
FailureCodes {
    private RoxAddress destinationId;
    private long millisecsTaken;
    private boolean success;
    private byte failCode;
    private String failString;
    private byte ttl;

    PingResult(RoxAddress destId, byte ttl) {
        this.destinationId = destId;
        this.ttl = ttl;
        this.success = true;
    }

    PingResult(RoxAddress destId, byte failCode, String failString, byte ttl) {
        this.destinationId = destId;
        this.failCode = failCode;
        this.failString = failString;
        this.ttl = ttl;
        this.success = false;
    }

    void setTimeTaken(long tTaken) {
        this.millisecsTaken = tTaken;
    }

    public RoxAddress getDestinationId() {
        return this.destinationId;
    }

    public long timeTakenMillis() {
        return this.millisecsTaken;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public byte failureCode() {
        return this.failCode;
    }

    public String failureCodeString() {
        return TransportControlMessage.getCodeString(this.failCode);
    }

    public String failureString() {
        return this.failString;
    }

    public byte getTTL() {
        return this.ttl;
    }

    void hideTTLFailure() {
        if (!this.success && this.failCode == 6) {
            this.success = true;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":dest:" + this.destinationId + ":" + (this.success ? ":success:" : ":failCode:" + this.failureCodeString() + ":failString:" + this.failString) + ":ttl:" + this.ttl + ":time:" + this.millisecsTaken;
    }

    private PingResult() {
    }
}

