/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;

public final class ConnectionSetupAttribute
implements RPCSerializable {
    public static final String TYPE_RAW = ConnectionType.RAW.toString();
    public static final String TYPE_SSH = ConnectionType.SSH.toString();
    public static final String TYPE_SSL = ConnectionType.SSL.toString();
    private String address;
    private int port;
    private ConnectionType type;
    private String parameters;

    private ConnectionSetupAttribute() {
    }

    public ConnectionSetupAttribute(String ipAddress, int port, ConnectionType type, String parms) {
        this.address = ipAddress;
        this.port = port;
        this.type = type;
        this.parameters = parms;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getType() {
        return this.type.toString();
    }

    public ConnectionType getConnectionType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ConnectionSetupAttribute) {
            ConnectionSetupAttribute csa = (ConnectionSetupAttribute)obj;
            return csa.address.equals(this.address) && csa.port == this.port && csa.type.equals(this.type) && csa.parameters.equals(this.parameters);
        }
        return false;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "ConnectionSetupAttribute:ipAddress" + this.address + ":port:" + this.port + ":type:" + this.type + ":parameters:" + this.parameters;
    }
}

