/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.ClientConnectionManager;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SSLFactory;
import com.raplix.rolloutexpress.net.transport.ServerConnectionManager;
import com.raplix.rolloutexpress.net.transport.ShutdownInitiated;
import com.raplix.rolloutexpress.net.transport.StdIOConnectionManager;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.rolloutexpress.net.transport.TransportMessage;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.util.logger.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public final class ConnectionManager {
    public final int CONNECTION_HANDSHAKE_TIMEOUT;
    public final int CONNECTION_SERVER_BACKLOG;
    public final int CONNECTION_TIMEOUT_TASK_RANGE;
    private Vector threadsForStart = new Vector();
    private boolean threadsStarted = false;
    private Hashtable remoteConnections = new Hashtable();
    private HashSet localConnections = new HashSet();
    private ClientConnectionManager clientConnManager;
    private ServerConnectionManager serverConnManager;
    private StdIOConnectionManager ioConnManager;
    private TransportManager tManager;
    private boolean shutdownInitiated = false;
    private SSLFactory mSSLFactory;
    private boolean mInitializeSSL = false;

    static ConnectionManager create(NetSubsystem nss, TransportManager tMgr, InputStream is, OutputStream os, RoxAddress local, RoxAddress remote) throws TransportException, ConfigurationException {
        ConnectionManager mgr = new ConnectionManager(nss, tMgr);
        mgr.mInitializeSSL = true;
        mgr.serverConnManager = null;
        mgr.ioConnManager = new StdIOConnectionManager(mgr, tMgr.getRouteTable(), is, os, local, remote, nss);
        tMgr.getRouteTable().setDefaultRoute(remote);
        return mgr;
    }

    static ConnectionManager create(NetSubsystem nss, TransportManager tMgr, boolean noMultipleServerConn) throws ConfigurationException, TransportException {
        ConnectionManager mgr = new ConnectionManager(nss, tMgr);
        mgr.mInitializeSSL = true;
        mgr.serverConnManager = new ServerConnectionManager(mgr, tMgr.getRouteTable(), noMultipleServerConn);
        mgr.ioConnManager = null;
        return mgr;
    }

    static ConnectionManager createForLocal(NetSubsystem nss, TransportManager tMgr) throws ConfigurationException, TransportException {
        ConnectionManager mgr = new ConnectionManager(nss, tMgr);
        mgr.serverConnManager = null;
        mgr.ioConnManager = null;
        return mgr;
    }

    private ConnectionManager(NetSubsystem nss, TransportManager tMgr) throws ConfigurationException, TransportException {
        this.CONNECTION_HANDSHAKE_TIMEOUT = nss.getConfigConnectionHandshakeTimeout();
        this.CONNECTION_SERVER_BACKLOG = nss.getConfigConnectionServerBacklog();
        this.CONNECTION_TIMEOUT_TASK_RANGE = nss.getConfigConnectionTimeoutTaskRange();
        this.tManager = tMgr;
        this.clientConnManager = new ClientConnectionManager(nss, this);
        nss.getScheduler().scheduleTask(new TimeOutConnections(), nss.getConfigConnectionTimeoutTaskInterval());
    }

    public void addClientConnection(ConnectionSetupAttribute csa) throws TransportException {
        if (this.shutdownInitiated) {
            throw new ShutdownInitiated();
        }
        RoxAddress ra = new RoxAddress(csa.getAddress(), csa.getPort());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Add conn:" + csa, this);
        }
        this.clientConnManager.addConnectionSetupAttribute(ra, csa);
        this.tManager.getRouteTable().addStaticRoute(ra, ra);
        if (ConnectionType.SSL.equals(csa.getConnectionType())) {
            this.getSSLFactory();
        }
    }

    public void removeClientConnection(ConnectionSetupAttribute csa) throws TransportException {
        RoxAddress ra = new RoxAddress(csa.getAddress(), csa.getPort());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Remove conn:" + csa, this);
        }
        this.clientConnManager.removeConnectionSetupAttribute(ra, csa);
        this.tManager.getRouteTable().removeStaticRoute(ra);
        Connection c = (Connection)this.remoteConnections.get(ra);
        if (c != null) {
            c.releaseConnection();
        }
    }

    public void addServerConnection(ConnectionSetupAttribute csa) throws TransportException {
        if (this.serverConnManager == null) {
            throw new TransportException(NetMessageCode.TRNS_SERVER_CONN_NOT_AVAILABLE);
        }
        if (this.shutdownInitiated) {
            throw new ShutdownInitiated();
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Server:" + csa, this);
        }
        this.serverConnManager.startServer(csa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnectionTo(RoxAddress remoteAddress) throws TransportException {
        if (this.shutdownInitiated) {
            throw new ShutdownInitiated();
        }
        Connection c = null;
        c = (Connection)this.remoteConnections.get(remoteAddress);
        if (c == null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                c = (Connection)this.remoteConnections.get(remoteAddress);
                if (c == null) {
                    c = this.clientConnManager.setupConnectionTo(remoteAddress);
                }
            }
        }
        return c;
    }

    public int getNumActiveConnections() {
        return this.remoteConnections.size();
    }

    void receivedMessage(Connection c, TransportMessage msg) {
        this.tManager.handleMessage(msg, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(Connection conn) {
        Hashtable hashtable = this.remoteConnections;
        synchronized (hashtable) {
            this.remoteConnections.put(conn.getRemoteId(), conn);
        }
    }

    void addLocalEndpoint(RoxAddress ra) {
        this.localConnections.add(ra);
    }

    void removeLocalEndpoint(RoxAddress ra) {
        this.localConnections.remove(ra);
    }

    void undeliveredMessage(TransportMessage msg, Exception ex) {
        this.tManager.undeliveredMessage(msg, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(Connection con) {
        Object obj;
        Hashtable hashtable = this.remoteConnections;
        synchronized (hashtable) {
            obj = this.remoteConnections.remove(con.getRemoteId());
        }
        if (obj == null) {
            Logger.error("releaseConnection notification for the connection not found in the connection table:" + con, this);
        } else if (Logger.isInfoEnabled(this)) {
            Logger.info("Removed Connection:" + con, this);
        }
        if (this.remoteConnections.size() == 0) {
            this.tManager.noConnections();
        }
    }

    boolean isLocal(RoxAddress address) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("isLocal:" + address + ":local:" + this.localConnections, this);
        }
        return RoxAddress.local.equals(address) || this.localConnections.contains(address);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized SSLFactory getSSLFactory() throws TransportException {
        if (this.mSSLFactory == null) {
            if (!this.mInitializeSSL) throw new TransportException(NetMessageCode.TRNS_SSL_NOT_CONFIGURED);
            this.mSSLFactory = SSLFactory.init(this.tManager.getNetSubsystem(), false);
            return this.mSSLFactory;
        }
        if (!this.mSSLFactory.requiresRefresh()) return this.mSSLFactory;
        try {
            this.mSSLFactory = this.mSSLFactory.refresh(this.tManager.getNetSubsystem());
            if (!Logger.isDebugEnabled(ConnectionManager.class)) return this.mSSLFactory;
            Logger.debug("Refreshed SSL keystore", ConnectionManager.class);
            return this.mSSLFactory;
        }
        catch (TransportException ex) {
            if (!Logger.isWarnEnabled(ConnectionManager.class)) return this.mSSLFactory;
            Logger.warn("Exception while refreshing keystores. Returning existing SSLFactory.", ex, ConnectionManager.class);
        }
        return this.mSSLFactory;
    }

    void closedIOConnection() {
        this.tManager.closedMainConnection();
    }

    public String toString() {
        return this.getClass().getName() + "RemoteConn:" + this.remoteConnections + ":localEndpoints:" + this.localConnections + "\nClientCon:" + this.clientConnManager + "\nServerCon:" + this.serverConnManager + "\nStdio:" + this.ioConnManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAllThreads() {
        Thread thread = null;
        Vector vector = this.threadsForStart;
        synchronized (vector) {
            if (!this.threadsStarted) {
                Enumeration enu = this.threadsForStart.elements();
                while (enu.hasMoreElements()) {
                    thread = (Thread)enu.nextElement();
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Starting:" + thread, this);
                    }
                    thread.start();
                }
            }
            this.threadsStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownConnections() {
        if (this.serverConnManager != null) {
            this.serverConnManager.shutdownServers();
        }
        Vector connections = new Vector();
        Enumeration<Object> enu = null;
        Hashtable hashtable = this.remoteConnections;
        synchronized (hashtable) {
            if (this.shutdownInitiated) {
                return;
            }
            this.shutdownInitiated = true;
            enu = this.remoteConnections.elements();
            while (enu.hasMoreElements()) {
                connections.add(enu.nextElement());
            }
        }
        enu = connections.elements();
        while (enu.hasMoreElements()) {
            ((Connection)enu.nextElement()).releaseConnection();
        }
    }

    void setClientLocalEndpointAddress(RoxAddress address) {
        this.tManager.setClientNodeAddress(address);
    }

    TransportManager getTransportManager() {
        return this.tManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnectionTimeout() {
        Vector connections = new Vector();
        Enumeration<Object> enu = null;
        Hashtable hashtable = this.remoteConnections;
        synchronized (hashtable) {
            enu = this.remoteConnections.elements();
            while (enu.hasMoreElements()) {
                connections.add(enu.nextElement());
            }
        }
        enu = connections.elements();
        while (enu.hasMoreElements()) {
            ((Connection)enu.nextElement()).testTimeOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerThreadForStart(Thread thread) {
        Vector vector = this.threadsForStart;
        synchronized (vector) {
            if (this.threadsStarted) {
                thread.start();
            } else {
                this.threadsForStart.add(thread);
            }
        }
    }

    boolean isIOConnManagerInit() {
        return this.ioConnManager != null;
    }

    private class TimeOutConnections
    implements Runnable {
        private TimeOutConnections() {
        }

        public void run() {
            ConnectionManager.this.checkConnectionTimeout();
        }

        public String toString() {
            return "Time out Connections";
        }
    }
}

