/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.HandshakeConductor;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.net.transport.TransportMessage;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import com.raplix.util.threads.Uninterruptible;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

class Connection {
    private boolean handshakeComplete = false;
    private boolean handshakeNotified = false;
    private Object handshakeCompleteLock = new Object();
    private boolean released = false;
    protected boolean closed = false;
    private OutputStream outputStream;
    private InputStream inputStream;
    private ReadThread readThread;
    private ConnectionEventListener cListener;
    private RoxAddress local;
    private RoxAddress remote;
    private TransportInfo transportInfo;
    private int timeOutCounter;
    private String mConnType;

    Connection(ConnectionEventListener cListener, InputStream is, OutputStream os, RoxAddress local, RoxAddress remote, TransportInfo info, String connType) throws TransportException {
        this.local = local;
        this.remote = remote;
        this.cListener = cListener;
        this.inputStream = is;
        this.outputStream = os;
        this.transportInfo = info;
        this.timeOutCounter = cListener.CONNECTION_TIMEOUT_TASK_RANGE;
        this.mConnType = connType;
    }

    void postCreate() throws TransportException {
        try {
            this.cListener.createdConnection(this);
        }
        catch (TransportException te) {
            this.close();
            throw te;
        }
        boolean handshakeCompleted = false;
        try {
            this.initializeThreads();
            if (this.transportInfo.isClientSide()) {
                this.waitForHandshake();
            }
            handshakeCompleted = true;
        }
        catch (Exception ie) {
            throw new TransportException(NetMessageCode.TRNS_HANDSHAKE_WRITE_ERR, (Throwable)ie);
        }
        finally {
            if (!handshakeCompleted) {
                this.releaseConnection();
            }
        }
    }

    public RoxAddress getLocalId() {
        return this.local;
    }

    public RoxAddress getRemoteId() {
        return this.remote;
    }

    public void send(TransportMessage msg) throws TransportException {
        this.resetTimeOut();
        if (this.closed) {
            throw new TransportException(NetMessageCode.TRNS_CONN_CLOSED);
        }
        Exception ex = null;
        this.waitForHandshake();
        try {
            try {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Sending packet:" + msg, this);
                }
                this.writeUnInterrupted(msg.body, 0, msg.getLength() + 21);
            }
            catch (Exception ie) {
                ex = ie;
                if (this.closed) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug(":Closing Connection:" + this, ie, this);
                    }
                } else if (Logger.isErrorEnabled(this)) {
                    Logger.error("Error writing to the output stream:" + this, ie, this);
                }
                throw new TransportException(NetMessageCode.TRNS_ERR_PACKET_WRITE, (Throwable)ie, (Object[])new String[]{msg.toString()});
            }
            Object var5_3 = null;
            if (ex != null) {
                this.releaseConnection();
                this.messageNotDelivered(msg, ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (ex != null) {
                this.releaseConnection();
                this.messageNotDelivered(msg, ex);
            }
            throw throwable;
        }
    }

    private void initializeThreads() {
        this.readThread = new ReadThread();
        this.cListener.registerThreadForStart(this.readThread);
    }

    protected synchronized void close() {
        block4: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Closing connection", this);
            }
            try {
                new Uninterruptible(){

                    protected Object execute() throws Exception {
                        block6: {
                            block5: {
                                try {
                                    Connection.this.outputStream.close();
                                }
                                catch (IOException e) {
                                    if (!Logger.isDebugEnabled(this)) break block5;
                                    Logger.debug("Exception when closing connection outputstream:" + this, e, this);
                                }
                            }
                            try {
                                if (Connection.this.readThread != null) {
                                    Connection.this.readThread.interruptSafe();
                                }
                                Connection.this.inputStream.close();
                            }
                            catch (IOException e) {
                                if (!Logger.isDebugEnabled(this)) break block6;
                                Logger.debug("Exception when closing connection inputstream:" + this, e, this);
                            }
                        }
                        return null;
                    }
                }.run();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block4;
                Logger.error("Unexpected error closing connection", e, this);
            }
        }
    }

    public String toString() {
        return "Connection [" + this.local + "]-[" + this.remote + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeCompleted(boolean result) {
        Object object = this.handshakeCompleteLock;
        synchronized (object) {
            this.handshakeComplete = result;
            this.handshakeNotified = true;
            this.handshakeCompleteLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForHandshake() throws TransportException {
        int connType = this.getConnTypeNum();
        if (!this.handshakeNotified) {
            Object object = this.handshakeCompleteLock;
            synchronized (object) {
                try {
                    if (!this.handshakeNotified) {
                        this.handshakeCompleteLock.wait(this.cListener.CONNECTION_HANDSHAKE_TIMEOUT);
                    }
                }
                catch (InterruptedException e) {
                    throw new TransportException(NetMessageCode.TRNS_CONN_WAIT_HANDSHAKE_INTERRUPTED, (Throwable)e, new Object[]{new Integer(connType), this.getAdditionalFailureInfo()});
                }
            }
        }
        if (!this.handshakeNotified) {
            throw new TransportException(NetMessageCode.TRNS_CONN_HANDSHAKE_TIME_OUT, new Object[]{String.valueOf(this.cListener.CONNECTION_HANDSHAKE_TIMEOUT), new Integer(connType), this.getAdditionalFailureInfo()});
        }
        if (!this.handshakeComplete) {
            throw new TransportException(NetMessageCode.TRNS_CONN_HANDSHAKE_FAILED, new Object[]{new Integer(connType), this.getAdditionalFailureInfo()});
        }
    }

    TransportInfo getTransportInfo() {
        return this.transportInfo;
    }

    protected synchronized void releaseConnection() {
        if (!this.released) {
            this.close();
            this.cListener.releaseConnection(this);
            this.released = true;
        }
    }

    private void receiveMessage(TransportMessage msg) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("received Message:" + msg, this);
        }
        this.resetTimeOut();
        this.cListener.receivedMessage(this, msg);
    }

    private void messageNotDelivered(TransportMessage msg, Exception ex) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("undelivered message:" + msg, ex, this);
        }
        this.cListener.messageNotDelivered(msg, ex);
    }

    private void writeUnInterrupted(final byte[] bytes, final int offset, final int size) throws Exception {
        new Uninterruptible(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object execute() throws Exception {
                OutputStream outputStream = Connection.this.outputStream;
                synchronized (outputStream) {
                    Connection.this.outputStream.write(bytes, offset, size);
                }
                Connection.this.outputStream.flush();
                return null;
            }
        }.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doHandshake() throws TransportException {
        HandshakeConductor handshake = this.cListener.getHandshaker();
        byte[] data = null;
        byte[] lengthBuf = new byte[4];
        boolean complete = false;
        Vector<Object> readStrings = new Vector<Object>();
        try {
            try {
                this.writeUnInterrupted(HandshakeConductor.PRELIM_HANDSHAKE, 0, HandshakeConductor.PRELIM_HANDSHAKE.length);
                data = new byte[HandshakeConductor.PRELIM_HANDSHAKE.length];
                if (!this.readBytes(data, 0, data.length) || !Arrays.equals(HandshakeConductor.PRELIM_HANDSHAKE, data)) {
                    throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE, new Object[]{Connection.toHexString(data)});
                }
                data = null;
                int i = 0;
                while (!handshake.isHandshakeComplete()) {
                    int length;
                    if ((data = handshake.handshake(data, i)) != null) {
                        length = data.length;
                        this.writeUnInterrupted(Connection.convert(data.length, lengthBuf), 0, lengthBuf.length);
                        this.writeUnInterrupted(data, 0, data.length);
                    }
                    if (!handshake.isHandshakeComplete()) {
                        if (!this.readBytes(lengthBuf, 0, lengthBuf.length)) {
                            throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE, new Object[]{Connection.toHexString(lengthBuf)});
                        }
                        readStrings.add(lengthBuf.clone());
                        length = Connection.convert(lengthBuf);
                        data = new byte[length];
                        if (!this.readBytes(data, 0, length)) {
                            throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE, new Object[]{Connection.toHexString(data)});
                        }
                        readStrings.add(data);
                    }
                    ++i;
                }
                return;
            }
            catch (TransportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (complete || !Logger.isInfoEnabled(this)) throw throwable;
            Enumeration e = readStrings.elements();
            while (e.hasMoreElements()) {
                Logger.info(new String((byte[])e.nextElement()), this);
            }
            throw throwable;
        }
    }

    private static String toHexString(byte[] data) {
        BigInteger bi = new BigInteger(data);
        return bi.toString(16);
    }

    private static byte[] convert(int i, byte[] b) {
        b[0] = (byte)(0xFF & i >> 24);
        b[1] = (byte)(0xFF & i >> 16);
        b[2] = (byte)(0xFF & i >> 8);
        b[3] = (byte)(0xFF & i);
        return b;
    }

    private static int convert(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    private boolean readBytes(byte[] buffer, int offset, int requestBytes) throws IOException {
        while (requestBytes > 0) {
            int bytesRead = this.inputStream.read(buffer, offset, requestBytes);
            if (bytesRead < 0) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("End of inputStream, returning", this);
                }
                return false;
            }
            offset += bytesRead;
            requestBytes -= bytesRead;
        }
        return true;
    }

    synchronized void testTimeOut() {
        if (--this.timeOutCounter < 0) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Timing out connection:" + this, this);
            }
            this.close();
        }
    }

    private synchronized void resetTimeOut() {
        this.timeOutCounter = this.cListener.CONNECTION_TIMEOUT_TASK_RANGE;
    }

    private int getConnTypeNum() {
        if (ConnectionSetupAttribute.TYPE_RAW.equals(this.mConnType)) {
            return 0;
        }
        if (ConnectionSetupAttribute.TYPE_SSL.equals(this.mConnType)) {
            return 2;
        }
        return 1;
    }

    public String getAdditionalFailureInfo() {
        return "";
    }

    private class ReadThread
    extends SafeThread {
        ReadThread() {
            super(Connection.this.toString() + ":Reader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean isHandshakeComplete = false;
                try {
                    Connection.this.doHandshake();
                    isHandshakeComplete = true;
                }
                catch (TransportException te) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Handshake failed:", te, this);
                    }
                    throw te;
                }
                finally {
                    Connection.this.handshakeCompleted(isHandshakeComplete);
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Handshake completed!", this);
                }
                while (!ReadThread.interrupted()) {
                    TransportMessage msg = TransportMessage.createMessage();
                    if (!Connection.this.readBytes(msg.body, 0, 21)) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("End of inputStream reading header, returning", this);
                        }
                        return;
                    }
                    if (msg.getLength() > 1379) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Protocol Violation, Aborting connection:Invalid packet length:" + msg.getLength(), this);
                        }
                        return;
                    }
                    if (!Connection.this.readBytes(msg.body, 21, msg.getLength())) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("End of inputStream reading packet body, returning", this);
                        }
                        return;
                    }
                    Connection.this.receiveMessage(msg);
                }
            }
            catch (Exception e) {
                if (Connection.this.closed) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug(":Closing connection:" + Connection.this, e, this);
                    }
                } else if (Logger.isErrorEnabled(this)) {
                    Logger.error("Exception when reading from connection input:" + Connection.this + ":Closing connection:", e, this);
                }
            }
            finally {
                Connection.this.releaseConnection();
            }
        }
    }
}

