/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.transport.HandshakeConductor;
import com.raplix.rolloutexpress.net.transport.HandshakeData;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.HashSet;

class ClientHandshakeConductor
implements HandshakeConductor {
    private boolean mIsComplete = false;
    private boolean mForceCompatibilityMode;
    private HashSet mCompatibleVersions;
    private RoxAddress mMSAddress;

    public byte[] handshake(byte[] receivedValue, int iteration) throws TransportException {
        switch (iteration) {
            case 0: {
                return null;
            }
            case 1: {
                try {
                    String version = new String(receivedValue);
                    if (Logger.isInfoEnabled(this)) {
                        Logger.info("received app version:" + version, this);
                    }
                    HandshakeData data = new HandshakeData(this.mMSAddress, this.mForceCompatibilityMode || !this.mCompatibleVersions.contains(version));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(data);
                    oos.close();
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                catch (IOException e) {
                    throw new TransportException(NetMessageCode.TRNS_CONN_INVALID_HANDSHAKE, (Throwable)e, new Object[]{new BigInteger(receivedValue).toString(16)});
                }
                finally {
                    this.mIsComplete = true;
                }
            }
        }
        return null;
    }

    public ClientHandshakeConductor(HashSet inCompatibleVersions, RoxAddress inMSAddress, boolean forceCompatibilityMode) {
        this.mCompatibleVersions = (HashSet)inCompatibleVersions.clone();
        this.mMSAddress = inMSAddress;
        this.mForceCompatibilityMode = forceCompatibilityMode;
    }

    public boolean isHandshakeComplete() {
        return this.mIsComplete;
    }
}

