/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.transport.ClientConnectionSetupHandler;
import com.raplix.rolloutexpress.net.transport.ClientHandshakeConductor;
import com.raplix.rolloutexpress.net.transport.Connection;
import com.raplix.rolloutexpress.net.transport.ConnectionEventListener;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.HandshakeConductor;
import com.raplix.rolloutexpress.net.transport.RawClientConnectionHandler;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SSLClientConnectionHandler;
import com.raplix.rolloutexpress.net.transport.SetupException;
import com.raplix.rolloutexpress.net.transport.SshClientConnectionHandler;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;

public final class ClientConnectionManager
extends ConnectionEventListener {
    private Hashtable connectionAttributes = new Hashtable();
    private Hashtable connectionSetupHandlers = new Hashtable();

    ClientConnectionManager(NetSubsystem nss, ConnectionManager cMgr) throws ConfigurationException {
        super(cMgr);
        this.connectionSetupHandlers.put(ConnectionSetupAttribute.TYPE_RAW, new RawClientConnectionHandler());
        this.connectionSetupHandlers.put(ConnectionSetupAttribute.TYPE_SSH, new SshClientConnectionHandler(nss));
        this.connectionSetupHandlers.put(ConnectionSetupAttribute.TYPE_SSL, new SSLClientConnectionHandler());
    }

    void addConnectionSetupAttribute(RoxAddress addr, ConnectionSetupAttribute csa) throws TransportException {
        this.connectionAttributes.put(addr, csa);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Added Client connection:" + csa, this);
        }
    }

    void removeConnectionSetupAttribute(RoxAddress addr, ConnectionSetupAttribute csa) throws TransportException {
        if (this.connectionAttributes.remove(addr) == null) {
            throw new TransportException(NetMessageCode.TRNS_CLIENT_CANNOT_REMOVE_CONN, (Object[])new String[]{csa.toString()});
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Removed Client connection:" + csa, this);
        }
    }

    public void createdConnection(Connection c) {
        this.cManager.addConnection(c);
        this.cManager.addLocalEndpoint(c.getLocalId());
        this.cManager.setClientLocalEndpointAddress(c.getLocalId());
    }

    public void releaseConnection(Connection c) {
        this.cManager.releaseConnection(c);
        this.cManager.removeLocalEndpoint(c.getLocalId());
    }

    HandshakeConductor getHandshaker() {
        TransportManager tMgr = this.cManager.getTransportManager();
        return new ClientHandshakeConductor(tMgr.getCompatibleVersions(), tMgr.getMSAddress(), tMgr.getIsCompatibilityMode());
    }

    public Connection setupConnectionTo(RoxAddress addr) throws TransportException {
        ConnectionSetupAttribute csa = (ConnectionSetupAttribute)this.connectionAttributes.get(addr);
        if (csa == null) {
            throw new SetupException(NetMessageCode.TRNS_CLIENT_CONN_SETUP_NOINFO, (Object[])new String[]{addr.toString()});
        }
        ClientConnectionSetupHandler csh = (ClientConnectionSetupHandler)this.connectionSetupHandlers.get(csa.getType());
        if (csh == null) {
            throw new SetupException(NetMessageCode.TRNS_CLIENT_CONN_SETUP_NOHANDLER, (Object[])new String[]{addr.toString(), csa.getType()});
        }
        Connection conn = null;
        try {
            conn = csh.setupConnection(this, csa, addr);
        }
        catch (TransportException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Error setting up connection to:" + addr, e, this);
            }
            throw e;
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info("Created client connection:" + conn, this);
        }
        return conn;
    }

    public String toString() {
        return this.getClass().getName() + ":conAttr:" + this.connectionAttributes + ":setupHandlers:" + this.connectionSetupHandlers;
    }
}

