/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.AcceptsUpstreamInvocations;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.AccessDeniedException;
import com.raplix.rolloutexpress.net.rpc.Command;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCUtils;
import com.raplix.rolloutexpress.net.rpc.Result;
import com.raplix.rolloutexpress.net.rpc.SelectiveSessionValidation;
import com.raplix.rolloutexpress.net.rpc.UnexpectedException;
import com.raplix.util.logger.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Hashtable;

class ServiceImpl {
    private final RPCInterface impl;
    private final Hashtable methodTable;
    private final boolean mIsUpstreamInvocable;
    private Hashtable validationReqdMethodTable = new Hashtable();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$net$rpc$SelectiveSessionValidation;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$net$rpc$BypassSessionValidation;

    ServiceImpl(Class serviceInterface, RPCInterface implementation) {
        this.impl = implementation;
        this.methodTable = new Hashtable();
        this.mIsUpstreamInvocable = AcceptsUpstreamInvocations.class.isAssignableFrom(serviceInterface);
        this.initMethodTable(serviceInterface);
    }

    private void initMethodTable(Class serviceInterface) {
        boolean canDoSelectiveSessionValidation = false;
        boolean canBypassSessionValidation = false;
        String[] selectiveSessionMethodNames = null;
        if (RPCInterface.class.isAssignableFrom(serviceInterface)) {
            Class<?>[] superIntfs = serviceInterface.getInterfaces();
            for (int i = 0; i < superIntfs.length; ++i) {
                if (superIntfs[i].equals(class$com$raplix$rolloutexpress$net$rpc$SelectiveSessionValidation == null ? ServiceImpl.class$("com.raplix.rolloutexpress.net.rpc.SelectiveSessionValidation") : class$com$raplix$rolloutexpress$net$rpc$SelectiveSessionValidation)) {
                    canDoSelectiveSessionValidation = true;
                    canBypassSessionValidation = false;
                    selectiveSessionMethodNames = ((SelectiveSessionValidation)((Object)this.impl)).disableChecksFor();
                    break;
                }
                if (!superIntfs[i].equals(class$com$raplix$rolloutexpress$net$rpc$BypassSessionValidation == null ? ServiceImpl.class$("com.raplix.rolloutexpress.net.rpc.BypassSessionValidation") : class$com$raplix$rolloutexpress$net$rpc$BypassSessionValidation)) continue;
                canBypassSessionValidation = true;
            }
            Method[] methods = serviceInterface.getDeclaredMethods();
            for (int k = 0; k < methods.length; ++k) {
                String methodName = methods[k].getName();
                String methodSignature = RPCUtils.getMethodSignature(methods[k]);
                methods[k].setAccessible(true);
                if (canBypassSessionValidation) {
                    this.validationReqdMethodTable.put(methodSignature, new Boolean(false));
                } else if (canDoSelectiveSessionValidation) {
                    boolean valueSet = false;
                    for (int i = 0; i < selectiveSessionMethodNames.length; ++i) {
                        if (!RPCUtils.isMethodNameSame(methodSignature, selectiveSessionMethodNames[i])) continue;
                        this.validationReqdMethodTable.put(methodSignature, new Boolean(false));
                        valueSet = true;
                        break;
                    }
                    if (!valueSet) {
                        this.validationReqdMethodTable.put(methodSignature, new Boolean(true));
                    }
                } else {
                    this.validationReqdMethodTable.put(methodSignature, new Boolean(true));
                }
                this.methodTable.put(methodSignature, methods[k]);
            }
            for (int i = 0; i < superIntfs.length; ++i) {
                this.initMethodTable(superIntfs[i]);
            }
        }
    }

    Result invoke(Command c) throws CommandException {
        Method m = null;
        Object returnValue = null;
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ServiceImpl:invoke:call:" + c, this);
            }
            if ((m = (Method)this.methodTable.get(c.getMethodName())) != null) {
                Object[] suppliedParms = c.getParameterValues();
                Class<?>[] neededParms = m.getParameterTypes();
                if (suppliedParms == null && neededParms.length != 0 || suppliedParms != null && neededParms.length != suppliedParms.length) {
                    throw new RPCException(NetMessageCode.RPC_SERV_IMPL_PARAMETER_CNT_MISMATCH, (Object[])new String[]{String.valueOf(neededParms.length), String.valueOf(suppliedParms.length)});
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("All went well, invoking the method:" + m, this);
                }
                returnValue = m.invoke((Object)this.impl, suppliedParms);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("method invocation was successful:returned:" + returnValue, this);
                }
                return new Result(c.getTargetName(), c.getMethodName(), returnValue);
            }
            throw new RPCException(NetMessageCode.RPC_SERV_IMPL_METHOD_NOT_FOUND, (Object[])new String[]{c.getMethodName(), c.toString()});
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof CommandException) {
                throw (CommandException)t;
            }
            if (t instanceof AccessControlException) {
                throw new AccessDeniedException((AccessControlException)t);
            }
            throw new UnexpectedException(NetMessageCode.RPC_UNEXPECTED_EXCEPTION, t);
        }
        catch (IllegalAccessException iae) {
            throw new RPCException(NetMessageCode.RPC_SERV_IMPL_ILLEGAL_ACCESS, (Throwable)iae);
        }
        catch (IllegalArgumentException e) {
            throw new RPCException(NetMessageCode.RPC_SERV_IMPL_ILLEGAL_ARGS, (Throwable)e);
        }
    }

    RPCInterface getImplementation() {
        return this.impl;
    }

    boolean isUpstreamInvocable() {
        return this.mIsUpstreamInvocable;
    }

    boolean isSessionValidationRequired(Command command) {
        if (this.validationReqdMethodTable.get(command.getMethodName()) != null) {
            return (Boolean)this.validationReqdMethodTable.get(command.getMethodName());
        }
        return true;
    }

    public String toString() {
        return "ServiceImpl:" + this.impl.getClass().getName() + ":methodTable:" + this.methodTable;
    }
}

