/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.JavaSerializationProvider;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.SerializationProvider;
import java.io.IOException;

public class SerializationProviderFactory {
    private static final String SOAP_SERIAL_PROVIDER_CLASS = "com.raplix.rolloutexpress.net.rpc.soap.SOAPSerializationProvider";

    static SerializationProvider createJavaProvider() {
        return new JavaSerializationProvider();
    }

    static SerializationProvider createSoapProvider(Application app) throws RPCException {
        try {
            return (SerializationProvider)app.getAppImplClassLoader().loadClass(SOAP_SERIAL_PROVIDER_CLASS).newInstance();
        }
        catch (IOException ioe) {
            throw new RPCException(NetMessageCode.RPC_ERR_INIT_SERIALIZER, (Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RPCException(NetMessageCode.RPC_ERR_INIT_SERIALIZER, (Throwable)cnfe);
        }
        catch (InstantiationException ine) {
            throw new RPCException(NetMessageCode.RPC_ERR_INIT_SERIALIZER, (Throwable)ine);
        }
        catch (IllegalAccessException iae) {
            throw new RPCException(NetMessageCode.RPC_ERR_INIT_SERIALIZER, (Throwable)iae);
        }
    }
}

