/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.JavaSerializationProvider;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.ObjectInputStream;

public final class SerializableReference
implements RPCSerializable {
    private RoxAddress address;
    private String interfaceName;
    private transient RPCManager rpcManager;

    private SerializableReference() {
    }

    SerializableReference(String interfaceName, RoxAddress address) {
        this.interfaceName = interfaceName;
        this.address = address;
    }

    public RPCInterface getReference() throws RPCException {
        try {
            return this.rpcManager.getService(this.address, this.getInterfaceClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RPCException(NetMessageCode.RPC_SERIAL_REF_NO_LOCAL_CLASS, (Object[])new String[]{cnfe.toString()});
        }
    }

    public Class getInterfaceClass() throws ClassNotFoundException {
        return Class.forName(this.interfaceName);
    }

    void setRPCManager(RPCManager mgr) {
        this.rpcManager = mgr;
    }

    public String toString() {
        return "SerializedReference:" + this.interfaceName + "@" + this.address;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("reading serializable ref" + stream, this);
        }
        stream.defaultReadObject();
        if (stream instanceof JavaSerializationProvider.RPCObjectInputStream) {
            this.rpcManager = ((JavaSerializationProvider.RPCObjectInputStream)stream).getRPCManager();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Initialized serializable ref with rpcManager", this);
            }
        }
    }
}

