/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.ValidationFailed;
import com.sun.n1.util.RPCSerializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public final class RPCUtils {
    static /* synthetic */ Class class$com$raplix$rolloutexpress$net$rpc$RPCInterface;
    static /* synthetic */ Class class$java$lang$Throwable;

    private RPCUtils() {
    }

    public static void validateException(Class c) throws ValidationFailed {
        HashSet tmp1 = new HashSet();
        HashSet tmp2 = new HashSet();
        RPCUtils.validateException(c, tmp1, tmp2);
    }

    public static void validateSerializable(Class c) throws ValidationFailed {
        HashSet tmp1 = new HashSet();
        HashSet tmp2 = new HashSet();
        RPCUtils.validateParameter(c, tmp1, tmp2);
    }

    public static void validateInterface(Class intf) throws ValidationFailed {
        RPCUtils.collectBeans(intf);
    }

    public static Class[] collectBeans(Class c) throws ValidationFailed {
        HashSet classes = new HashSet();
        RPCUtils.validateClass(c, classes);
        Class[] returnValue = new Class[classes.size()];
        return classes.toArray(returnValue);
    }

    private static void addClass(Set classes, Class c, Set inProcess) {
        if (classes.contains(c)) {
            return;
        }
        if (c.isArray()) {
            RPCUtils.addClass(classes, c.getComponentType(), inProcess);
        } else if (!(c.isPrimitive() || c.equals(String.class) || RPCException.class.isAssignableFrom(c))) {
            classes.add(c);
            inProcess.remove(c);
        }
    }

    public static boolean isMethodNameSame(String signature, String methodName) {
        return signature.equals(methodName) || signature.startsWith(methodName + "_");
    }

    public static String getMethodSignature(Method m) {
        StringBuffer sign = new StringBuffer(m.getName());
        Class<?>[] parms = m.getParameterTypes();
        for (int j = 0; j < parms.length; ++j) {
            sign.append('_');
            sign.append(RPCUtils.getClassName(parms[j]));
        }
        return sign.toString().replace('[', '.').replace(']', '_');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void validateClass(Class c, Set classes) throws ValidationFailed {
        HashSet inProcess = new HashSet();
        if (!c.isInterface()) throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_NOT_INTERFACE, (Object[])new String[]{c.toString()});
        Class<?>[] intfs = c.getInterfaces();
        boolean extendsRPCInterface = false;
        for (int k = 0; k < intfs.length; ++k) {
            if (!intfs[k].equals(class$com$raplix$rolloutexpress$net$rpc$RPCInterface == null ? RPCUtils.class$("com.raplix.rolloutexpress.net.rpc.RPCInterface") : class$com$raplix$rolloutexpress$net$rpc$RPCInterface)) continue;
            extendsRPCInterface = true;
        }
        if (!extendsRPCInterface) throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_EXTEND_RPCINTERFACE, (Object[])new String[]{c.toString()});
        Method[] methods = c.getDeclaredMethods();
        if (methods.length <= 0) return;
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            boolean includesRPCException = false;
            for (j = 0; j < exceptions.length; ++j) {
                RPCUtils.validateException(exceptions[j], classes, inProcess);
                if (!exceptions[j].equals(class$com$raplix$rolloutexpress$net$rpc$RPCException == null ? RPCUtils.class$("com.raplix.rolloutexpress.net.rpc.RPCException") : class$com$raplix$rolloutexpress$net$rpc$RPCException)) continue;
                includesRPCException = true;
            }
            if (!includesRPCException) {
                throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_NO_RPCEXCEPTION, (Object[])new String[]{methods[i].toString()});
            }
            Class<?>[] parameters = methods[i].getParameterTypes();
            for (j = 0; j < parameters.length; ++j) {
                RPCUtils.validateParameter(parameters[j], classes, inProcess);
            }
            RPCUtils.validateParameter(methods[i].getReturnType(), classes, inProcess);
        }
    }

    static void validateException(Class c, Set classes, Set inProcess) throws ValidationFailed {
        if (!CommandException.class.isAssignableFrom(c)) {
            throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_EXCEPTION, (Object[])new String[]{c.toString()});
        }
        RPCUtils.validateBean(c, classes, inProcess);
    }

    public static void validateParameter(Class c, Set classes, Set inProcess) throws ValidationFailed {
        if (c.isPrimitive() || c.equals(String.class) || c.equals(Vector.class) || c.equals(Hashtable.class) || c.equals(Date.class)) {
            return;
        }
        if (c.isArray()) {
            RPCUtils.validateParameter(c.getComponentType(), classes, inProcess);
            return;
        }
        if (CommandException.class.isAssignableFrom(c)) {
            RPCUtils.validateException(c, classes, inProcess);
        } else if (RPCSerializable.class.isAssignableFrom(c)) {
            RPCUtils.validateBean(c, classes, inProcess);
            Class superClass = c.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && RPCUtils.hasSerializableFields(superClass)) {
                RPCUtils.validateParameter(superClass, classes, inProcess);
            }
        } else {
            throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_INVALID_TYPE, (Object[])new String[]{c.toString()});
        }
    }

    public static void validateBean(Class c, Set classes, Set inProcess) throws ValidationFailed {
        if (!RPCSerializable.class.isAssignableFrom(c)) {
            throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_TYPE_NOT_SERIALIZABLE, (Object[])new String[]{c.toString()});
        }
        if (inProcess.contains(c) || classes.contains(c)) {
            return;
        }
        inProcess.add(c);
        if (!c.isInterface()) {
            Constructor<?> defaultConstructor = null;
            Constructor<?>[] construct = c.getDeclaredConstructors();
            for (int k = 0; k < construct.length; ++k) {
                if (construct[k].getParameterTypes().length != 0) continue;
                defaultConstructor = construct[k];
            }
            if (defaultConstructor == null) {
                throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_NO_DEFAULT_CONSTRUCTOR, (Object[])new String[]{c.toString()});
            }
        }
        try {
            Class tmp = c;
            Field[] fields = null;
            Field field = null;
            HashSet<String> fieldNames = new HashSet<String>();
            do {
                fields = tmp.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    field = fields[i];
                    int modifier = field.getModifiers();
                    if (Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) continue;
                    if (fieldNames.contains(fields[i].getName())) {
                        throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_DUPLICATE_FIELD, (Object[])new String[]{fields[i].getName(), c.toString()});
                    }
                    fieldNames.add(fields[i].getName());
                    if ((class$java$lang$Throwable == null ? RPCUtils.class$("java.lang.Throwable") : class$java$lang$Throwable).equals(tmp)) continue;
                    RPCUtils.validateParameter(field.getType(), classes, inProcess);
                }
            } while ((tmp = tmp.getSuperclass()) != null);
            RPCUtils.addClass(classes, c, inProcess);
        }
        catch (ValidationFailed v) {
            throw v;
        }
        catch (Exception e) {
            throw new ValidationFailed(NetMessageCode.RPC_VALIDATION_FAILED, (Throwable)e, (Object[])new String[]{c.toString()});
        }
    }

    static boolean hasSerializableFields(Class c) {
        do {
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers()) || Modifier.isTransient(fields[i].getModifiers())) continue;
                return true;
            }
        } while ((c = c.getSuperclass()) != null && !(class$java$lang$Object == null ? RPCUtils.class$("java.lang.Object") : class$java$lang$Object).equals(c));
        return false;
    }

    public static String getClassName(Class c) {
        if (c.isPrimitive()) {
            return c.getName();
        }
        if (c.isArray()) {
            return RPCUtils.getClassName(c.getComponentType()) + "[]";
        }
        return c.getName();
    }
}

