/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.command.ClientRequest;
import com.raplix.rolloutexpress.net.command.ProtocolException;
import com.raplix.rolloutexpress.net.command.RequestReply;
import com.raplix.rolloutexpress.net.command.ServerRequest;
import com.raplix.rolloutexpress.net.rpc.AccessControlProvider;
import com.raplix.rolloutexpress.net.rpc.Command;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.CompatibilityService;
import com.raplix.rolloutexpress.net.rpc.Context;
import com.raplix.rolloutexpress.net.rpc.ContextManager;
import com.raplix.rolloutexpress.net.rpc.LocalProxyHandler;
import com.raplix.rolloutexpress.net.rpc.ProxyHandler;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCServices;
import com.raplix.rolloutexpress.net.rpc.RPCServicesImpl;
import com.raplix.rolloutexpress.net.rpc.Result;
import com.raplix.rolloutexpress.net.rpc.SerializableReference;
import com.raplix.rolloutexpress.net.rpc.SerializationProvider;
import com.raplix.rolloutexpress.net.rpc.SerializationProviderFactory;
import com.raplix.rolloutexpress.net.rpc.ServiceImpl;
import com.raplix.rolloutexpress.net.rpc.ServiceUnavailableException;
import com.raplix.rolloutexpress.net.rpc.UnexpectedException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;

public class RPCManager
extends RequestReply {
    private boolean sendContexts = false;
    private boolean acceptContextOnServerEndpoint = false;
    private ContextManager ctxManager;
    private AccessControlProvider acProvider;
    private Hashtable serviceTable = null;
    private SerializationProvider provider;
    private SerializationProvider soapSerializationProvider;
    private final InheritableThreadLocal invokerAddress = new InheritableThreadLocal();
    private final InheritableThreadLocal invokerTransportInfo = new InheritableThreadLocal();
    private final InheritableThreadLocal mInvokedInterfaceName = new InheritableThreadLocal();
    private final InheritableThreadLocal mInvokedMethodSignature = new InheritableThreadLocal();

    private RPCManager(NetSubsystem nss) throws ConfigurationException {
        super(nss);
        this.ctxManager = new ContextManager();
        this.serviceTable = new Hashtable();
        try {
            this.soapSerializationProvider = SerializationProviderFactory.createSoapProvider(nss.getApplication());
            this.soapSerializationProvider.initialize(this);
            this.provider = SerializationProviderFactory.createJavaProvider();
            this.provider.initialize(this);
            RPCServicesImpl rpcServices = new RPCServicesImpl(this);
            this.registerService(RPCServices.class, rpcServices);
        }
        catch (RPCException re) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Could not initialize RPC services", re, this);
            }
            throw new ConfigurationException("net.rpc.init_failed", (Throwable)re);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info("Initialized RPCManager with serializer:" + this.provider, this);
        }
    }

    public static RPCManager createRPCForMS(NetSubsystem nss) throws ConfigurationException {
        RPCManager rpc = new RPCManager(nss);
        rpc.acceptContextOnServerEndpoint = true;
        return rpc;
    }

    public static RPCManager createRPCForNode(NetSubsystem nss) throws ConfigurationException {
        RPCManager rpc = new RPCManager(nss);
        return rpc;
    }

    public static RPCManager createRPCForClient(NetSubsystem nss) throws ConfigurationException {
        RPCManager rpc = new RPCManager(nss);
        rpc.sendContexts = true;
        return rpc;
    }

    public static RPCManager createRPCForTest(NetSubsystem nss) throws ConfigurationException {
        RPCManager rpc = new RPCManager(nss);
        rpc.sendContexts = nss.getRPCSendContext();
        rpc.acceptContextOnServerEndpoint = nss.getRPCAcceptContextOnServerEndpoint();
        if (Logger.isDebugEnabled(RPCManager.class)) {
            Logger.debug("sendCtx:" + rpc.sendContexts + ":acptCtx:" + rpc.acceptContextOnServerEndpoint, RPCManager.class);
        }
        return rpc;
    }

    public ContextManager getContextManager() {
        return this.ctxManager;
    }

    public RoxAddress getInvokerAddress() {
        RoxAddress ra = (RoxAddress)this.invokerAddress.get();
        return ra == null ? RoxAddress.local : ra;
    }

    public TransportInfo getInvokerTransportInfo() {
        TransportInfo info = (TransportInfo)this.invokerTransportInfo.get();
        if (info == null) {
            return TransportInfo.LOCAL;
        }
        return info;
    }

    public String getInvokedInterfaceName() {
        return (String)this.mInvokedInterfaceName.get();
    }

    public String getInvokedMethodSignature() {
        return (String)this.mInvokedMethodSignature.get();
    }

    public RPCInterface getService(RoxAddress ra, Class interfaceClass) throws RPCException {
        if (ra == null) {
            throw new RPCException(NetMessageCode.RPC_ROXADDRESS_NULL);
        }
        this.provider.validateInterface(interfaceClass);
        if (!interfaceClass.equals(RPCServices.class)) {
            try {
                if (this.getTransport().getIsCompatibilityMode() && !CompatibilityService.class.isAssignableFrom(interfaceClass) && !this.getTransport().isLocal(ra)) {
                    throw new RPCException(NetMessageCode.SYS_REQ_COMPATIBILITY_MODE, new Object[]{Application.getSubclassName(this.netSubsystem.getApplication().getClass()), this.netSubsystem.getApplication().getLocalNodeAddress().toString()});
                }
            }
            catch (TransportException e) {
                throw new ServiceUnavailableException(interfaceClass.toString(), ra);
            }
            RPCServices rpcServices = (RPCServices)this.getService(ra, RPCServices.class);
            if (!rpcServices.isRegistered(interfaceClass.getName())) {
                throw new ServiceUnavailableException(interfaceClass.toString(), ra);
            }
        }
        ProxyHandler ph = new ProxyHandler(interfaceClass.getName());
        RPCInterface ri = (RPCInterface)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)ph);
        ph.setRoxAddress(ra);
        ph.setRPCManager(this);
        return ri;
    }

    public RPCInterface getLocalService(RoxAddress ra, Class interfaceClass) throws RPCException {
        if (ra == null) {
            throw new RPCException(NetMessageCode.RPC_ROXADDRESS_NULL);
        }
        RPCInterface rpcInterface = this.getLocalRegisteredService(ra, interfaceClass.getName());
        if (rpcInterface == null) {
            return this.getService(ra, interfaceClass);
        }
        return rpcInterface;
    }

    public RPCInterface getLocalProxiedService(RoxAddress ra, Class interfaceClass) throws RPCException {
        if (ra == null) {
            throw new RPCException(NetMessageCode.RPC_ROXADDRESS_NULL);
        }
        RPCInterface rpcInterface = this.getLocalRegisteredService(ra, interfaceClass.getName());
        if (rpcInterface == null) {
            return this.getService(ra, interfaceClass);
        }
        return (RPCInterface)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LocalProxyHandler(interfaceClass, rpcInterface, this));
    }

    public SerializableReference getSerializableReference(Class interfaceClass) throws RPCException {
        try {
            if (this.isRegistered(interfaceClass.getName())) {
                SerializableReference sr = new SerializableReference(interfaceClass.getName(), this.getTransport().getNodeAddress());
                sr.setRPCManager(this);
                return sr;
            }
            throw new RPCException(NetMessageCode.RPC_SERIAL_REFERENCE_NO_SERVICE, (Object[])new String[]{interfaceClass.toString()});
        }
        catch (TransportException te) {
            throw new RPCException(NetMessageCode.RPC_SERIAL_REFERENCE_NO_ADDRESS, (Throwable)te);
        }
    }

    public byte getProtocolId() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(ServerRequest sr) {
        block24: {
            Result result;
            block23: {
                Command command = null;
                result = null;
                try {
                    block22: {
                        try {
                            ServiceImpl si;
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("invoked handleRequest:request:" + sr, this);
                            }
                            command = this.provider.unmarshallCommand(sr.getInputStream());
                            this.setInvokerDetails(sr.getSource(), sr.getTransportInfo(), command.getTargetName(), command.getMethodName());
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("Unmarshalled :" + command, this);
                            }
                            if ((si = (ServiceImpl)this.serviceTable.get(command.getTargetName())) == null) {
                                throw new RPCException(NetMessageCode.RPC_REQUEST_NO_IMPL, (Object[])new String[]{command.getTargetName()});
                            }
                            if (sr.getTransportInfo().isClientSide() && !si.isUpstreamInvocable()) {
                                throw new RPCException(NetMessageCode.RPC_UPSTREAM_REQUEST_DENIED, (Object[])new String[]{command.getTargetName()});
                            }
                            if (null != command.getContext() && (sr.getTransportInfo().isLocal() || sr.getTransportInfo().isServerSide() && this.acceptContextOnServerEndpoint)) {
                                this.getContextManager().setContext(command.getContext());
                            } else {
                                this.getContextManager().clearContext();
                            }
                            if (this.acProvider != null) {
                                PrivilegedMethodRunner pmr = new PrivilegedMethodRunner(si, command);
                                try {
                                    result = (Result)AccessController.doPrivileged(pmr, this.acProvider.provideAccessControl(si.isSessionValidationRequired(command), command.getTargetName() + "." + command.getMethodName()));
                                }
                                catch (PrivilegedActionException pae) {
                                    Exception ex = pae.getException();
                                    throw ex;
                                }
                            } else {
                                result = si.invoke(command);
                            }
                            if (!Logger.isDebugEnabled(this)) break block22;
                            Logger.debug("Got response:" + result, this);
                        }
                        catch (CommandException e) {
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("Got command exception when executing call:" + command, e, this);
                            }
                            result = command == null ? new Result("NULL", "void", e) : new Result(command.getTargetName(), command.getMethodName(), e);
                            Object var9_12 = null;
                            this.setInvokerDetails(null, null, null, null);
                            this.getContextManager().clearContext();
                            break block23;
                        }
                        catch (Throwable t) {
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("Got throwable when executing service", t, this);
                            }
                            result = command == null ? new Result("NULL", "void", new UnexpectedException(NetMessageCode.RPC_CANNOT_CREATE_CALL, t)) : new Result(command.getTargetName(), command.getMethodName(), new UnexpectedException(NetMessageCode.RPC_UNEXPECTED_EXCEPTION, t));
                            Object var9_13 = null;
                            this.setInvokerDetails(null, null, null, null);
                            this.getContextManager().clearContext();
                        }
                    }
                    Object var9_11 = null;
                    this.setInvokerDetails(null, null, null, null);
                    this.getContextManager().clearContext();
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    this.setInvokerDetails(null, null, null, null);
                    this.getContextManager().clearContext();
                    throw throwable;
                }
            }
            try {
                if (result == null) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Empty response in handleRequest", this);
                    }
                    sr.getOutputStream().close();
                } else {
                    this.provider.marshall(result, sr.getOutputStream());
                }
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block24;
                Logger.error("Exception when marshalling the response", e, this);
            }
        }
    }

    void setInvokerDetails(RoxAddress inAddress, TransportInfo inTransportInfo, String inIntfName, String inMethodSignature) {
        this.invokerAddress.set(inAddress);
        this.invokerTransportInfo.set(inTransportInfo);
        this.mInvokedInterfaceName.set(inIntfName);
        this.mInvokedMethodSignature.set(inMethodSignature);
    }

    public void registerService(Class interfaceClass, RPCInterface ri) throws RPCException {
        if (!RPCInterface.class.isAssignableFrom(interfaceClass)) {
            throw new RPCException(NetMessageCode.RPC_VALIDATION_INTERFACE, (Object[])new String[]{interfaceClass.toString()});
        }
        if (!interfaceClass.isAssignableFrom(ri.getClass())) {
            throw new RPCException(NetMessageCode.RPC_VALIDATION_IMPL_INTERFACE, (Object[])new String[]{ri.toString(), interfaceClass.toString()});
        }
        this.provider.validateInterface(interfaceClass);
        ServiceImpl si = new ServiceImpl(interfaceClass, ri);
        this.serviceTable.put(interfaceClass.getName(), si);
    }

    public void registerAccessControlProvider(AccessControlProvider acp) throws RPCException {
        if (this.acProvider != null) {
            throw new RPCException(NetMessageCode.RPC_ACCESS_CONTROL_ALREADY_REGISTERED, (Object[])new String[]{acp.toString(), this.acProvider.toString()});
        }
        this.acProvider = acp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unRegisterService(Class interfaceClass, RPCInterface service) throws RPCException {
        ServiceImpl sImpl = null;
        Hashtable hashtable = this.serviceTable;
        synchronized (hashtable) {
            sImpl = (ServiceImpl)this.serviceTable.get(interfaceClass.getName());
            if (sImpl == null) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("UnregisterService issued for an unregistered service:" + interfaceClass, this);
                }
                return false;
            }
            if (sImpl.getImplementation() == service) {
                this.serviceTable.remove(interfaceClass.getName());
                return true;
            }
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("Supplied implementation does not match with registered implementation:" + interfaceClass, this);
            }
            return false;
        }
    }

    Object invokeRemote(RoxAddress node, String interfaceName, String methodName, Class[] pTypes, Object[] pValues) throws RPCException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Invoking Remote:" + node + ":intf:" + interfaceName + ":method:" + methodName + ":values:" + (pValues != null ? Arrays.asList(pValues).toString() : null), this);
        }
        try {
            Context ctx = null;
            if (this.sendContexts || this.getTransport().isLocal(node)) {
                ctx = this.getContextManager().getContext();
            }
            ClientRequest cr = this.initiateRequest(node);
            this.provider.marshall(interfaceName, methodName, pTypes, pValues, ctx, cr.getOutputStream());
            InputStream is = this.getResponse(cr);
            return this.provider.unmarshallResult(is);
        }
        catch (IOException ioe) {
            throw new RPCException(NetMessageCode.RPC_SERV_INVOKE_RR_ERROR, (Throwable)ioe);
        }
        catch (ProtocolException pex) {
            throw new RPCException(NetMessageCode.RPC_SERV_INVOKE_RR_ERROR, (Throwable)pex);
        }
        catch (TransportException tex) {
            throw new RPCException(NetMessageCode.RPC_SERV_INVOKE_LOCAL_TRANSPORT_ERROR, (Throwable)tex, (Object[])new String[]{node.toString()});
        }
    }

    public void serializeObject(String id, Object rpcSerializable, Writer writer) throws RPCException {
        this.soapSerializationProvider.serializeObject(id, rpcSerializable, writer);
    }

    public Object deSerializeObject(String id, Reader reader) throws RPCException {
        return this.soapSerializationProvider.deSerializeObject(id, reader);
    }

    String[] listRegisteredServices() {
        Set set = this.serviceTable.keySet();
        String[] services = new String[set.size()];
        return set.toArray(services);
    }

    boolean isRegistered(String interfaceName) throws RPCException {
        try {
            if (this.getTransport().getIsCompatibilityMode()) {
                RoxAddress addr = this.getInvokerAddress();
                if (!CompatibilityService.class.isAssignableFrom(Class.forName(interfaceName)) && addr != null && !this.getTransport().isLocal(addr)) {
                    throw new RPCException(NetMessageCode.SYS_REQ_COMPATIBILITY_MODE, new Object[]{Application.getSubclassName(this.netSubsystem.getApplication().getClass()), this.netSubsystem.getApplication().getLocalNodeAddress().toString()});
                }
            }
        }
        catch (TransportException e) {
            throw new RPCException(NetMessageCode.RPC_SERVICE_LOCAL_TRANSPORT_ERROR, (Throwable)e, (Object[])new String[]{interfaceName, RoxAddress.local.toString()});
        }
        catch (ClassNotFoundException e) {
            throw new ServiceUnavailableException(interfaceName, RoxAddress.local);
        }
        return this.serviceTable.containsKey(interfaceName);
    }

    private RPCInterface getLocalRegisteredService(RoxAddress ra, String interfaceName) throws RPCException {
        try {
            if (this.getTransport().isLocal(ra)) {
                ServiceImpl servImpl = (ServiceImpl)this.serviceTable.get(interfaceName);
                RPCInterface rpcInterface = null;
                if (servImpl != null) {
                    rpcInterface = servImpl.getImplementation();
                }
                if (rpcInterface == null) {
                    throw new RPCException(NetMessageCode.RPC_LOCAL_SERVICE_UNAVAILABLE, new Object[]{interfaceName});
                }
                return rpcInterface;
            }
            return null;
        }
        catch (TransportException e) {
            throw new RPCException(NetMessageCode.RPC_SERVICE_LOCAL_TRANSPORT_ERROR, (Throwable)e, (Object[])new String[]{interfaceName, ra.toString()});
        }
    }

    public String toString() {
        return super.toString();
    }

    private static class PrivilegedMethodRunner
    implements PrivilegedExceptionAction {
        ServiceImpl si;
        Command c;

        PrivilegedMethodRunner(ServiceImpl si, Command c) {
            this.si = si;
            this.c = c;
        }

        public Object run() throws CommandException {
            return this.si.invoke(this.c);
        }
    }
}

