/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.AccessDeniedException;
import com.raplix.rolloutexpress.net.rpc.BaseStub;
import com.raplix.rolloutexpress.net.rpc.RPCAccessControlException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCUtils;
import com.raplix.rolloutexpress.net.rpc.UnexpectedException;
import com.raplix.util.logger.Logger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class ProxyHandler
extends BaseStub
implements InvocationHandler {
    private String intfName;

    public ProxyHandler(String interfaceName) {
        this.intfName = interfaceName;
    }

    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        String methodName;
        Object response;
        Class[] parameterTypes = method.getParameterTypes();
        if (method.getName().equals("toString")) {
            if (parameterTypes == null || parameterTypes.length == 0) {
                return this.toString();
            }
        } else if (method.getName().equals("hashCode")) {
            if (parameterTypes == null || parameterTypes.length == 0) {
                return new Integer(this.hashCode());
            }
        } else if (method.getName().equals("equals") && parameterTypes.length == 1 && parameterTypes[0].equals(Object.class)) {
            return new Boolean(this.equals(Proxy.getInvocationHandler(args)));
        }
        if ((response = this.invoke(this.intfName, methodName = RPCUtils.getMethodSignature(method), parameterTypes, args)) != null && response instanceof Throwable) {
            if (response instanceof AccessDeniedException) {
                throw new RPCAccessControlException((AccessDeniedException)response);
            }
            if (response instanceof RPCException) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("except:" + response.getClass() + ":" + response, this);
                }
                throw ((RPCException)response).fillInStackTrace();
            }
            Class<?>[] exceptions = method.getExceptionTypes();
            for (int j = 0; j < exceptions.length; ++j) {
                if (!exceptions[j].isAssignableFrom(response.getClass())) continue;
                throw ((Throwable)response).fillInStackTrace();
            }
            throw new UnexpectedException(NetMessageCode.RPC_UNEXPECTED_EXCEPTION, (Throwable)response);
        }
        return response;
    }

    protected String getInterfaceName() {
        return this.intfName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProxyHandler) {
            ProxyHandler ph = (ProxyHandler)obj;
            return ph.getInterfaceName().equals(this.getInterfaceName()) && ph.getRoxAddress().equals(this.getRoxAddress());
        }
        return false;
    }

    protected Class[] getClasses() {
        Class[] c = new Class[]{};
        return c;
    }

    public String toString() {
        return this.getClass().getName() + ":remote:" + this.intfName + ":addr:" + this.getRoxAddress();
    }
}

