/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.rpc.RPCUtils;
import com.raplix.rolloutexpress.net.rpc.UnexpectedException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class LocalProxyHandler
implements InvocationHandler {
    private RPCInterface mImpl;
    private RPCManager mRPCManager;
    private Class mIntfClass;

    public LocalProxyHandler(Class intfClass, RPCInterface inImpl, RPCManager inRPCManager) {
        if (inImpl == null) {
            throw new NullPointerException();
        }
        this.mIntfClass = intfClass;
        this.mImpl = inImpl;
        this.mRPCManager = inRPCManager;
    }

    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (method.getName().equals("toString")) {
            if (parameterTypes == null || parameterTypes.length == 0) {
                return this.mImpl.toString();
            }
        } else if (method.getName().equals("hashCode")) {
            if (parameterTypes == null || parameterTypes.length == 0) {
                return new Integer(this.mImpl.hashCode());
            }
        } else if (method.getName().equals("equals") && parameterTypes.length == 1 && parameterTypes[0].equals(Object.class)) {
            return new Boolean(this.mImpl.equals(args));
        }
        RoxAddress prevAddr = this.mRPCManager.getInvokerAddress();
        TransportInfo prevInfo = this.mRPCManager.getInvokerTransportInfo();
        String prevIntfName = this.mRPCManager.getInvokedInterfaceName();
        String prevMethodName = this.mRPCManager.getInvokedMethodSignature();
        try {
            this.mRPCManager.setInvokerDetails(RoxAddress.local, TransportInfo.LOCAL, this.mIntfClass.getName(), RPCUtils.getMethodSignature(method));
            method = this.lookupMethod(method);
            method.setAccessible(true);
            Object object = method.invoke((Object)this.mImpl, args);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException(NetMessageCode.RPC_UNEXPECTED_EXCEPTION, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new UnexpectedException(NetMessageCode.RPC_UNEXPECTED_EXCEPTION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            this.mRPCManager.setInvokerDetails(prevAddr, prevInfo, prevIntfName, prevMethodName);
        }
    }

    private Method lookupMethod(Method inMethod) throws UnexpectedException {
        NoSuchMethodException lastEx = null;
        for (Class<?> implClass = this.mImpl.getClass(); implClass != null; implClass = implClass.getSuperclass()) {
            try {
                return implClass.getDeclaredMethod(inMethod.getName(), inMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                lastEx = e;
                continue;
            }
        }
        throw new UnexpectedException(NetMessageCode.RPC_UNEXPECTED_EXCEPTION, (Throwable)lastEx);
    }
}

