/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.Command;
import com.raplix.rolloutexpress.net.rpc.Context;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.rpc.RPCUtils;
import com.raplix.rolloutexpress.net.rpc.Result;
import com.raplix.rolloutexpress.net.rpc.SerializationProvider;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Uninterruptible;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

class JavaSerializationProvider
extends SerializationProvider {
    private RPCManager rpcManager;

    JavaSerializationProvider() {
    }

    public void initialize(RPCManager rpcManager) throws RPCException {
        this.rpcManager = rpcManager;
    }

    public void validateInterface(Class c) throws RPCException {
        RPCUtils.collectBeans(c);
    }

    public void registerClasses(Class[] classes) throws RPCException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void marshall(String interfaceName, String methodName, Class[] pTypes, Object[] pValues, Context ctx, OutputStream os) throws IOException {
        ObjectOutputStream oos = null;
        try {
            Command command = new Command(interfaceName, methodName, ctx, pValues);
            oos = new RPCObjectOutputStream(os);
            ((RPCObjectOutputStream)oos).writeObjectUninterrupted(command);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void marshall(Result result, OutputStream os) throws IOException {
        RPCObjectOutputStream oos = null;
        try {
            oos = new RPCObjectOutputStream(os);
            oos.writeObjectUninterrupted(result);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command unmarshallCommand(InputStream is) throws Exception {
        Command command;
        block8: {
            RPCObjectInputStream ois = null;
            try {
                Command c;
                ois = new RPCObjectInputStream(this.rpcManager, is);
                command = c = (Command)ois.readObjectUninterrupted();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_6 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                            break block9;
                        }
                        is.close();
                    }
                    catch (IOException ioe) {
                        if (!Logger.isErrorEnabled(this)) break block9;
                        Logger.error("unexpected error closing stream", ioe, this);
                    }
                }
                throw throwable;
            }
            try {
                if (ois != null) {
                    ois.close();
                } else {
                    is.close();
                }
            }
            catch (IOException ioe) {
                if (!Logger.isErrorEnabled(this)) break block8;
                Logger.error("unexpected error closing stream", ioe, this);
            }
        }
        return command;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object unmarshallResult(InputStream is) throws RPCException {
        Object object;
        RPCObjectInputStream ois = null;
        try {
            try {
                ois = new RPCObjectInputStream(this.rpcManager, is);
                Result result = (Result)ois.readObjectUninterrupted();
                object = result == null ? null : result.getValue();
                Object var6_7 = null;
            }
            catch (IOException ioe) {
                throw new RPCException(NetMessageCode.RPC_SERV_INVOKE_RR_ERROR, (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RPCException(NetMessageCode.RPC_SERV_INVOKE_RR_ERROR, (Throwable)cnfe);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (ois != null) {
                    ois.close();
                    throw throwable;
                }
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                if (!Logger.isErrorEnabled(this)) throw throwable;
                Logger.error("unexpected error closing stream", ioe, this);
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            if (!Logger.isErrorEnabled(this)) return object;
            Logger.error("unexpected error closing stream", ioe, this);
            return object;
        }
        if (ois != null) {
            ois.close();
            return object;
        }
        is.close();
        return object;
    }

    public void serializeObject(String id, Object rpcSerializable, Writer writer) throws RPCException {
    }

    public Object deSerializeObject(String id, Reader reader) throws RPCException {
        return null;
    }

    static class RPCObjectOutputStream
    extends ObjectOutputStream {
        public RPCObjectOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        public void writeObjectUninterrupted(Object o) throws IOException {
            try {
                new Uninterruptible(this, o){
                    private final /* synthetic */ Object val$o;
                    private final /* synthetic */ RPCObjectOutputStream this$0;
                    {
                        this.this$0 = this$0;
                        this.val$o = val$o;
                    }

                    protected Object execute() throws IOException {
                        this.this$0.writeObject(this.val$o);
                        return null;
                    }
                }.run();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
        }
    }

    static class RPCObjectInputStream
    extends ObjectInputStream {
        private RPCManager rpcManager;

        RPCObjectInputStream(RPCManager inManager, InputStream is) throws IOException {
            super(is);
            this.rpcManager = inManager;
        }

        RPCManager getRPCManager() {
            return this.rpcManager;
        }

        public Object readObjectUninterrupted() throws ClassNotFoundException, IOException {
            try {
                return new Uninterruptible(this){
                    private final /* synthetic */ RPCObjectInputStream this$0;
                    {
                        this.this$0 = this$0;
                    }

                    protected Object execute() throws IOException, ClassNotFoundException {
                        return this.this$0.readObject();
                    }
                }.run();
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
        }
    }
}

