/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.Context;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.ContextManager;
import com.raplix.rolloutexpress.net.rpc.InvalidContext;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;

public abstract class ContextServices {
    private ContextManager ctxManager;

    protected ContextServices() {
    }

    protected final Context createContext(SessionID data) throws ContextException {
        if (this.ctxManager == null) {
            throw new ContextException(NetMessageCode.RPC_CONTEXT_SERVICE_NOT_REGISTERED);
        }
        return new Context(data);
    }

    protected final void setContext(Context ctx) throws ContextException {
        if (this.ctxManager == null) {
            throw new ContextException(NetMessageCode.RPC_CONTEXT_SERVICE_NOT_REGISTERED);
        }
        this.ctxManager.setContext(ctx);
    }

    protected final void clearContext() throws ContextException {
        if (this.ctxManager == null) {
            throw new ContextException(NetMessageCode.RPC_CONTEXT_SERVICE_NOT_REGISTERED);
        }
        this.ctxManager.clearContext();
    }

    protected final Context getContext() throws ContextException {
        if (this.ctxManager == null) {
            throw new ContextException(NetMessageCode.RPC_CONTEXT_SERVICE_NOT_REGISTERED);
        }
        return this.ctxManager.getContext();
    }

    final void setContextManager(ContextManager ctxMgr) {
        this.ctxManager = ctxMgr;
    }

    protected void validateContext(Context ctx) throws InvalidContext {
    }
}

