/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.Context;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.ContextServices;
import com.raplix.rolloutexpress.net.rpc.ContextValidator;
import com.raplix.rolloutexpress.net.rpc.InvalidContext;
import com.raplix.util.logger.Logger;

public class ContextManager {
    private static ContextWrapper contextWrapper = new ContextWrapper();
    private ContextServices registeredServices = null;
    private ContextValidator validator = null;

    ContextManager() {
    }

    void setContext(Context ctx) throws InvalidContext {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Set context:" + ctx + ":for:" + Thread.currentThread(), this);
        }
        this.validateContext(ctx);
        contextWrapper.set(ctx);
    }

    void clearContext() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Cleared context for:" + Thread.currentThread(), this);
        }
        contextWrapper.set(null);
    }

    public Context getContext() {
        return contextWrapper.getContext();
    }

    public void registerValidator(ContextValidator ctxValidator) throws ContextException {
        if (this.validator != null) {
            throw new ContextException(NetMessageCode.RPC_CONTEXT_VALIDATOR_ALREADY_REGISTERED, (Object[])new String[]{this.validator.toString(), ctxValidator.toString()});
        }
        this.validator = ctxValidator;
    }

    public void activateServices(ContextServices ctxServ) throws ContextException {
        if (this.registeredServices != null) {
            throw new ContextException(NetMessageCode.RPC_CONTEXT_SERVICES_ALREADY_REGISTERED, (Object[])new String[]{this.registeredServices.toString(), ctxServ.toString()});
        }
        ctxServ.setContextManager(this);
        this.registeredServices = ctxServ;
    }

    void validateContext(Context ctx) throws InvalidContext {
        if (this.validator != null) {
            this.validator.validate(ctx);
        }
    }

    private static class ContextWrapper
    extends InheritableThreadLocal {
        private ContextWrapper() {
        }

        public Object initialValue() {
            return null;
        }

        public Context getContext() {
            return (Context)this.get();
        }
    }
}

