/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.rpc;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class CommandException
extends RaplixException
implements RPCSerializable {
    private String mStackTrace;
    private String mNestedMessage;
    private int mNestedType = -1;
    private Severity mSeverity = Severity.ERROR;

    protected CommandException() {
    }

    protected CommandException(String message) {
        super(message);
    }

    protected CommandException(Throwable t) {
        super(t);
    }

    protected CommandException(String message, Object[] inArguments) {
        super(message, inArguments);
    }

    protected CommandException(ROXMessage inMessage) {
        super(inMessage);
    }

    protected CommandException(ROXMessage inMessage, Throwable inNestedException) {
        super(inMessage, inNestedException);
    }

    protected CommandException(ROXMessage inMessage, Throwable inNestedException, int inWrappingMode) {
        super(inMessage, inNestedException, inWrappingMode);
    }

    protected CommandException(String message, Throwable t) {
        super(message, t);
    }

    protected CommandException(String message, Throwable t, Object[] inArguments) {
        super(message, t, inArguments);
    }

    protected CommandException(NetMessageCode message) {
        super(message.getCode());
    }

    protected CommandException(NetMessageCode message, Object[] inArguments) {
        super(message.getCode(), inArguments);
    }

    protected CommandException(NetMessageCode message, Throwable t) {
        super(message.getCode(), t);
    }

    protected CommandException(NetMessageCode message, Throwable t, Object[] inArguments) {
        super(message.getCode(), t, inArguments);
    }

    public void printStackTrace(PrintStream ps) {
        if (this.mStackTrace != null) {
            ps.println(this.mStackTrace + "LocalTrace:");
        }
        super.printStackTrace(ps);
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.mStackTrace != null) {
            pw.println(this.mStackTrace + "LocalTrace:");
        }
        super.printStackTrace(pw);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    protected void readyToSerialize() {
        this.mNestedMessage = this.getNestedMessage();
        this.mNestedType = this.getNestedType();
        this.mSeverity = this.getNestedSeverity();
        this.mStackTrace = "Serialized Trace:" + Util.getStackTrace(this) + (this.mStackTrace == null ? "" : this.mStackTrace);
    }

    protected String getNestedMessage() {
        String msg = super.getNestedMessage();
        return msg == null ? this.mNestedMessage : msg;
    }

    protected int getNestedType() {
        int type = super.getNestedType();
        if (type == -1) {
            type = this.mNestedType;
        }
        return type;
    }

    protected Severity getNestedSeverity() {
        Severity severity = super.getNestedSeverity();
        if (severity == null) {
            severity = this.mSeverity;
        }
        return severity;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.readyToSerialize();
        oos.defaultWriteObject();
    }
}

