/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.CSOutputStream;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class VerifiableStream
extends CSOutputStream {
    public VerifiableStream(OutputStream os, int numLastBytes) throws FileTransferException {
        super(FileTransferManager.createDigestOutputStream(os), numLastBytes);
    }

    public void verifyCheckSum() throws FileTransferException {
        byte[] expChkSum;
        MessageDigest md = ((DigestOutputStream)this.out).getMessageDigest();
        byte[] actualChkSum = md.digest();
        if (!Arrays.equals(actualChkSum, expChkSum = this.getLastBytes())) {
            throw new FileTransferException(NetMessageCode.FT_CHECKSUM_MISMATCH, (Object[])new String[]{new BigInteger(expChkSum).toString(16), new BigInteger(actualChkSum).toString(16)});
        }
    }
}

