/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.FTDatagram;
import com.raplix.rolloutexpress.net.ft.FileDatagramDeliveryException;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.TimedOut;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.util.logger.Logger;

abstract class ResponseAcceptor {
    protected final int interactionId;
    protected final RoxAddress destId;
    private boolean notified = false;
    private boolean resetTimeout = false;
    protected FileTransferException error;

    protected ResponseAcceptor(RoxAddress dest, int interId) {
        this.interactionId = interId;
        this.destId = dest;
    }

    synchronized void waitForResponse(int waitTimeout) throws FileTransferException {
        try {
            while (!this.notified) {
                this.wait(waitTimeout);
                if (!this.resetTimeout) break;
                this.resetTimeout = false;
            }
            if (this.notified) {
                if (this.error == null) {
                    return;
                }
                throw this.error;
            }
            throw new TimedOut(NetMessageCode.FT_TRANSFER_TIMED_OUT, (Object[])new String[]{String.valueOf(waitTimeout)});
        }
        catch (InterruptedException ie) {
            throw new TimedOut(NetMessageCode.FT_WAIT_FOR_RESPONSE_INTERRUPTED, (Throwable)ie);
        }
    }

    protected void notifyError(ErrorDetails errDetails) {
        this.error = new FileDatagramDeliveryException(errDetails);
        this.notifyWaiter();
    }

    protected synchronized void notifyWaiter() {
        this.notify();
        this.notified = true;
    }

    protected synchronized void notifyResetTimeout() {
        this.notify();
        this.resetTimeout = true;
    }

    void receive(FTDatagram ftDatagram) throws MessageNotExpected {
        if (ftDatagram.getInteractionId() == this.interactionId) {
            if (ftDatagram.isErr()) {
                this.error = new FileTransferException(NetMessageCode.FT_TRANSFER_FAILED, (Object[])new String[]{ftDatagram.getErrString()});
                this.notifyWaiter();
            } else {
                this.accept(ftDatagram);
            }
        } else {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("Illegal Packet, interactionId doesn't match:" + ftDatagram + this, this);
            }
            throw new MessageNotExpected(NetMessageCode.FT_INTERACTION_ID_MISMATCH, (Object[])new String[]{ftDatagram.toString(), this.toString()});
        }
    }

    public String toString() {
        return "ResponseAcceptor:interactionId:" + this.interactionId + ":destination:" + this.destId;
    }

    protected abstract void accept(FTDatagram var1) throws MessageNotExpected;
}

