/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.FTDatagram;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.util.logger.Logger;

abstract class RequestAcceptor {
    protected final RoxAddress from;
    protected final int interactionId;
    protected final FileTransferManager ftManager;
    private int timeOutCounter;

    protected RequestAcceptor(FileTransferManager ftm, RoxAddress from, int interactionId) {
        this.from = from;
        this.interactionId = interactionId;
        this.ftManager = ftm;
        this.timeOutCounter = this.ftManager.STALE_REQUEST_TIMEOUT_TASK_RANGE;
    }

    void receive(FTDatagram ftd) throws MessageNotExpected {
        this.resetTimeout();
        if (!ftd.getPacket().getSourceId().equals(this.from) || ftd.getInteractionId() != this.interactionId) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Illegal Packet, source or interactionId do not match:" + ftd, this);
            }
            throw new MessageNotExpected(NetMessageCode.FT_PACKET_ID_MISMATCH, (Object[])new String[]{String.valueOf(ftd), this.toString()});
        }
        this.accept(ftd);
    }

    abstract void errorDeliveringPacket(ErrorDetails var1);

    protected abstract void accept(FTDatagram var1) throws MessageNotExpected;

    synchronized boolean testTimeout() {
        return --this.timeOutCounter < 1;
    }

    protected synchronized void resetTimeout() {
        this.timeOutCounter = this.ftManager.STALE_REQUEST_TIMEOUT_TASK_RANGE;
    }

    public String toString() {
        return "RequestAcceptor:from:" + this.from + ":interactionId:" + this.interactionId;
    }
}

