/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.ft.ChecksumAppender;
import com.raplix.rolloutexpress.net.ft.CompatibilityHandler;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FTDatagram;
import com.raplix.rolloutexpress.net.ft.FTGetRequest;
import com.raplix.rolloutexpress.net.ft.FTGetResponse;
import com.raplix.rolloutexpress.net.ft.FTKey;
import com.raplix.rolloutexpress.net.ft.FTSendRequest;
import com.raplix.rolloutexpress.net.ft.FTSendResponse;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferHandler;
import com.raplix.rolloutexpress.net.ft.RequestAcceptor;
import com.raplix.rolloutexpress.net.ft.ResponseAcceptor;
import com.raplix.rolloutexpress.net.ft.VerifiableStream;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.ProtocolManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.net.transport.TransportMessage;
import com.raplix.util.logger.Logger;
import com.raplix.util.threadpool.NoMoreThreads;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class FileTransferManager
extends ProtocolManager {
    public static final String DIGEST_ALGORITHM = "MD5";
    private Hashtable transferHandlers = new Hashtable();
    private NetSubsystem netSubsystem;
    private Hashtable pendingResponseTable = new Hashtable();
    private Hashtable pendingRequestTable = new Hashtable();
    private int interactionId = 1;
    public final int RESPONSE_WAIT_TIMEOUT;
    public final int STALE_REQUEST_TIMEOUT_TASK_RANGE;
    static final int REQUEST_HEADER_LENGTH = 17;

    public FileTransferManager(NetSubsystem nss) throws ConfigurationException {
        this.netSubsystem = nss;
        this.RESPONSE_WAIT_TIMEOUT = nss.getConfigFTResponseWaitTimeout();
        this.STALE_REQUEST_TIMEOUT_TASK_RANGE = nss.getConfigFTStaleRequestTimeoutTaskRange();
        nss.getScheduler().scheduleTask(new TimeOutStaleRequests(), nss.getConfigFTStaleRequestTimeoutTaskInterval());
    }

    public byte getProtocolId() {
        return 2;
    }

    public static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(DIGEST_ALGORITHM);
    }

    protected final void sendFTMessage(FTDatagram msg) throws TransportException {
        this.sendMessage(msg.getPacket());
    }

    protected void receiveMessage(TransportMessage msg) throws MessageNotExpected {
        FTDatagram ftDatagram = new FTDatagram(msg);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Received packet:" + ftDatagram, this);
        }
        if (ftDatagram.getVersion() != 1) {
            Object[] objectArray = new String[2];
            objectArray[0] = String.valueOf(1);
            objectArray[1] = String.valueOf(ftDatagram.getVersion());
            throw new MessageNotExpected(NetMessageCode.FT_UNSUPPORTED_VERSION, objectArray);
        }
        try {
            if (ftDatagram.isReq()) {
                if (ftDatagram.getSequenceId() == 1) {
                    if (ftDatagram.isGet()) {
                        FTGetRequest fgr = FTGetRequest.createGetRequest(this, ftDatagram);
                        if (fgr != null) {
                            this.pendingRequestTable.put(new FTKey(fgr.interactionId, fgr.from), fgr);
                            this.netSubsystem.getThreadPool().start(fgr);
                        }
                        return;
                    }
                    if (ftDatagram.isSend()) {
                        FTSendRequest fsr = FTSendRequest.createSendRequest(this, ftDatagram);
                        if (fsr != null) {
                            this.pendingRequestTable.put(new FTKey(fsr.interactionId, fsr.from), fsr);
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("pending table:" + this.pendingRequestTable, this);
                            }
                            fsr.accept(ftDatagram);
                        }
                        return;
                    }
                    if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Unexpected packet, neither GET nor SEND:" + ftDatagram, this);
                    }
                    throw new MessageNotExpected(NetMessageCode.FT_PACKET_NEITHER_SEND_NOR_GET, (Object[])new String[]{ftDatagram.toString()});
                }
                FTKey ftk = new FTKey(ftDatagram.getInteractionId(), ftDatagram.getPacket().getSourceId());
                RequestAcceptor rap = (RequestAcceptor)this.pendingRequestTable.get(ftk);
                if (rap == null) {
                    if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Unexpected request packet, no pending requests found:" + ftDatagram + ":tbl:" + this.pendingRequestTable, this);
                    }
                    throw new MessageNotExpected(NetMessageCode.FT_PACKET_NO_PENDING_REQUEST, (Object[])new String[]{ftDatagram.toString(), this.pendingRequestTable.toString()});
                }
                rap.receive(ftDatagram);
                return;
            }
            ResponseAcceptor ra = (ResponseAcceptor)this.pendingResponseTable.get(new Integer(ftDatagram.getInteractionId()));
            if (ra != null) {
                ra.receive(ftDatagram);
                return;
            }
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("Unexpected reply packet received:" + ftDatagram, this);
            }
        }
        catch (NoMoreThreads nmt) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Cannot handle request for datagram:" + ftDatagram, nmt, this);
            }
            this.sendError(msg.getSourceId(), ftDatagram.getInteractionId(), (byte)2, nmt);
        }
    }

    void sendData(RoxAddress destination, DataId dataIdentifier, InputStream is, FileTransferHandler fth) throws FileTransferException {
        if (this.netSubsystem.getTransport().getIsCompatibilityMode() && !(fth instanceof CompatibilityHandler)) {
            throw new FileTransferException(NetMessageCode.SYS_REQ_COMPATIBILITY_MODE, new Object[]{Application.getSubclassName(this.netSubsystem.getApplication().getClass()), this.netSubsystem.getApplication().getLocalNodeAddress().toString()});
        }
        FTDatagram ftDatagram = null;
        int seqId = 1;
        boolean eof = false;
        Integer interId = new Integer(this.getInteractionId());
        try {
            is = FileTransferManager.createChecksumAppender(is);
            FTSendResponse ftr = new FTSendResponse(destination, interId);
            this.pendingResponseTable.put(interId, ftr);
            ftDatagram = new FTDatagram(destination, interId, seqId, 69);
            int offset = 31;
            offset += FileTransferManager.writeRequestHeader(ftDatagram, fth.getHandlerId(), dataIdentifier);
            while (!eof) {
                int bytesRead = 0;
                int requestBytes = 1399 - offset;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Requesting:" + requestBytes, this);
                }
                while (true) {
                    if (offset >= 1399) break;
                    bytesRead = is.read(ftDatagram.getBody(), offset, requestBytes);
                    if (bytesRead < 0) {
                        eof = true;
                        break;
                    }
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Read:" + bytesRead + ":Req:" + requestBytes + ":off:" + offset + ":max:" + 1399, this);
                    }
                    offset += bytesRead;
                    requestBytes -= bytesRead;
                }
                if (eof) {
                    ftDatagram.setFlags((byte)(ftDatagram.getFlags() | 8));
                }
                ftDatagram.setBodyLength(offset - 31);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Sending:" + ftDatagram, this);
                }
                this.sendMessage(ftDatagram.getPacket());
                ftDatagram = null;
                ++seqId;
                if (!eof) {
                    ftDatagram = new FTDatagram(destination, interId, seqId, 69);
                    offset = 31;
                }
                Thread.yield();
                ftr.checkForErrorResponse();
            }
            ftr.waitForResponse(this.RESPONSE_WAIT_TIMEOUT);
        }
        catch (TransportException te) {
            throw new FileTransferException(NetMessageCode.FT_TRANSFER_FAILED_TRANSPORT_ERROR, (Throwable)te);
        }
        catch (IOException ie) {
            if (seqId > 1) {
                this.sendError(destination, (int)interId, (byte)65, ie);
            }
            throw new FileTransferException(NetMessageCode.FT_TRANSFER_FAILED_ERROR_FILE_READ, (Throwable)ie);
        }
        finally {
            this.pendingResponseTable.remove(interId);
        }
    }

    void getData(RoxAddress fromId, DataId dataIdentifier, OutputStream os, FileTransferHandler fth) throws FileTransferException {
        if (this.netSubsystem.getTransport().getIsCompatibilityMode() && !(fth instanceof CompatibilityHandler)) {
            throw new FileTransferException(NetMessageCode.SYS_REQ_COMPATIBILITY_MODE, new Object[]{Application.getSubclassName(this.netSubsystem.getApplication().getClass()), this.netSubsystem.getApplication().getLocalNodeAddress().toString()});
        }
        Integer interId = new Integer(this.getInteractionId());
        FTDatagram ftDatagram = null;
        try {
            FTGetResponse fgr = new FTGetResponse(this, fromId, interId, FileTransferManager.createVerifiableStream(os));
            this.pendingResponseTable.put(interId, fgr);
            ftDatagram = new FTDatagram(fromId, interId, 1, (byte)(2 | 0x40));
            int length = FileTransferManager.writeRequestHeader(ftDatagram, fth.getHandlerId(), dataIdentifier);
            ftDatagram.setBodyLength(length);
            this.sendMessage(ftDatagram.getPacket());
            fgr.waitForResponse(this.RESPONSE_WAIT_TIMEOUT);
        }
        catch (TransportException te) {
            throw new FileTransferException(NetMessageCode.FT_TRANSFER_FAILED_TRANSPORT_ERROR, (Throwable)te);
        }
        finally {
            this.pendingResponseTable.remove(interId);
        }
    }

    protected void errorDeliveringMessage(TransportMessage originalPacketFragment, ErrorDetails errDetails) {
        FTDatagram ftd = new FTDatagram(originalPacketFragment);
        if (ftd.isReq()) {
            int interId = ftd.getInteractionId();
            ResponseAcceptor rAccpt = (ResponseAcceptor)this.pendingResponseTable.get(new Integer(interId));
            if (rAccpt != null) {
                rAccpt.notifyError(errDetails);
            } else if (Logger.isWarnEnabled(this)) {
                Logger.warn("Error delivering packet for unknown request:" + originalPacketFragment + "Fault:" + errDetails, this);
            }
        } else {
            FTKey ftk = new FTKey(ftd.getInteractionId(), ftd.getPacket().getDestinationId());
            RequestAcceptor reqAccpt = (RequestAcceptor)this.pendingRequestTable.get(ftk);
            if (reqAccpt != null) {
                reqAccpt.errorDeliveringPacket(errDetails);
            } else if (Logger.isWarnEnabled(this)) {
                Logger.warn("Error delivering packet for unknown response:" + originalPacketFragment + "Fault:" + errDetails, this);
            }
        }
    }

    void requestDoneGET(FTGetRequest fgr) {
        FTKey ftk = new FTKey(fgr.interactionId, fgr.from);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("requestDoneGET:" + ftk, this);
        }
        if (this.pendingRequestTable.remove(ftk) == null) {
            Logger.warn("GET done notification for a non-pending request:" + ftk, this);
        }
    }

    void requestDoneSEND(FTSendRequest ftr) {
        FTKey ftk = new FTKey(ftr.interactionId, ftr.from);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("requestDoneSEND:" + ftk, this);
        }
        if (this.pendingRequestTable.remove(ftk) == null) {
            Logger.warn("SEND done notification for a non-pending request:" + ftk, this);
        }
    }

    public void registerHandler(FileTransferHandler fth) throws FileTransferException {
        Byte b = new Byte(fth.getHandlerId());
        Object obj = this.transferHandlers.get(b);
        if (obj != null) {
            throw new FileTransferException(NetMessageCode.FT_HANDLER_ID_CLASH, (Object[])new String[]{String.valueOf(b), String.valueOf(obj)});
        }
        this.transferHandlers.put(b, fth);
        fth.setFTManager(this);
    }

    FileTransferHandler getHandler(byte handlerId, TransportInfo inTransportInfo) throws FileTransferException {
        Byte b = new Byte(handlerId);
        FileTransferHandler fth = (FileTransferHandler)this.transferHandlers.get(b);
        if (fth == null) {
            throw new FileTransferException(NetMessageCode.FT_NO_HANDLER_FOR_ID, (Object[])new String[]{String.valueOf(handlerId)});
        }
        if (this.netSubsystem.getTransport().getIsCompatibilityMode() && !(fth instanceof CompatibilityHandler)) {
            throw new FileTransferException(NetMessageCode.SYS_REQ_COMPATIBILITY_MODE, new Object[]{Application.getSubclassName(this.netSubsystem.getApplication().getClass()), this.netSubsystem.getApplication().getLocalNodeAddress().toString()});
        }
        if (inTransportInfo.isClientSide() && !fth.isUpstreamInvocable()) {
            throw new FileTransferException(NetMessageCode.FT_UPSTREAM_REQUEST_DENIED, (Object[])new String[]{String.valueOf(handlerId)});
        }
        return fth;
    }

    public String[] listHandlerClassNames() {
        LinkedList<String> fthClassNames = new LinkedList<String>();
        Iterator iterator = this.transferHandlers.values().iterator();
        while (iterator.hasNext()) {
            fthClassNames.add(iterator.next().getClass().getName());
        }
        return fthClassNames.toArray(new String[fthClassNames.size()]);
    }

    void sendError(RoxAddress dest, int interactionId, byte flags, Throwable t) {
        this.sendError(dest, interactionId, flags, t.toString());
    }

    void sendError(RoxAddress dest, int interactionId, byte flags, String errString) {
        block2: {
            FTDatagram ftd = new FTDatagram(dest, interactionId, 0, (byte)(flags | 0x20));
            ftd.setErrString(errString);
            try {
                this.sendMessage(ftd.getPacket());
            }
            catch (TransportException te) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Error sending error packet:" + ftd, te, this);
            }
        }
    }

    void sendAck(RoxAddress dest, int interactionId, byte flags) {
        block2: {
            FTDatagram ftd = new FTDatagram(dest, interactionId, 0, (byte)(flags | 0x10));
            ftd.setBodyLength(0);
            try {
                this.sendMessage(ftd.getPacket());
            }
            catch (TransportException te) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Error sending error packet:" + ftd, te, this);
            }
        }
    }

    static int writeRequestHeader(FTDatagram ftd, byte handlerId, DataId dataId) {
        ftd.getBody()[31] = handlerId;
        dataId.writeByteArray(ftd.getBody(), 31 + 1);
        return 17;
    }

    static byte readRequestHeaderHandlerId(FTDatagram ftd) {
        return ftd.getBody()[31];
    }

    static DataId readRequestHeaderDataId(FTDatagram ftd) {
        return new DataId(ftd.getBody(), 31 + 1);
    }

    synchronized int getInteractionId() {
        if (this.interactionId < Integer.MAX_VALUE) {
            return this.interactionId++;
        }
        this.interactionId = 1;
        return 1;
    }

    private void checkRequestsForTimeout() {
        Vector requestsToBeRemoved = new Vector();
        Enumeration<Object> enu = this.pendingRequestTable.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            if (!((RequestAcceptor)this.pendingRequestTable.get(key)).testTimeout()) continue;
            requestsToBeRemoved.add(key);
        }
        enu = requestsToBeRemoved.elements();
        while (enu.hasMoreElements()) {
            Object req = enu.nextElement();
            this.pendingRequestTable.remove(req);
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("Deleting stale request:" + req, this);
        }
    }

    static DigestInputStream createDigestInputStream(InputStream is) throws FileTransferException {
        try {
            return new DigestInputStream(is, FileTransferManager.getMessageDigest());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FileTransferException(NetMessageCode.FT_CANNOT_LOAD_ALGO, (Throwable)nsae, (Object[])new String[]{DIGEST_ALGORITHM});
        }
    }

    static DigestOutputStream createDigestOutputStream(OutputStream os) throws FileTransferException {
        try {
            return new DigestOutputStream(os, FileTransferManager.getMessageDigest());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FileTransferException(NetMessageCode.FT_CANNOT_LOAD_ALGO, (Throwable)nsae, (Object[])new String[]{DIGEST_ALGORITHM});
        }
    }

    public static VerifiableStream createVerifiableStream(OutputStream os) throws FileTransferException {
        try {
            return new VerifiableStream(os, FileTransferManager.getMessageDigest().getDigestLength());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new FileTransferException(NetMessageCode.FT_CANNOT_LOAD_ALGO, (Throwable)nsae, (Object[])new String[]{DIGEST_ALGORITHM});
        }
    }

    public static ChecksumAppender createChecksumAppender(InputStream is) throws FileTransferException {
        return new ChecksumAppender(is);
    }

    private class TimeOutStaleRequests
    implements Runnable {
        private TimeOutStaleRequests() {
        }

        public void run() {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Checking for stale requests", this);
            }
            FileTransferManager.this.checkRequestsForTimeout();
        }
    }
}

