/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.AcceptsUpstreamInvocations;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FileHandlerException;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FileTransferHandler {
    private FileTransferManager ftManager;

    protected FileTransferHandler() {
    }

    protected final void sendData(RoxAddress destination, InputStream data, DataId dataIdentifier) throws FileTransferException {
        if (this.ftManager == null) {
            throw new FileTransferException(NetMessageCode.FT_HANDLER_NOT_REGISTERED);
        }
        this.ftManager.sendData(destination, dataIdentifier, data, this);
    }

    protected final void getData(RoxAddress from, OutputStream store, DataId dataIdentifier) throws FileTransferException {
        if (this.ftManager == null) {
            throw new FileTransferException(NetMessageCode.FT_HANDLER_NOT_REGISTERED);
        }
        this.ftManager.getData(from, dataIdentifier, store, this);
    }

    protected abstract OutputStream storeData(RoxAddress var1, TransportInfo var2, DataId var3) throws FileHandlerException;

    protected abstract InputStream fetchData(RoxAddress var1, DataId var2, TransportInfo var3) throws FileHandlerException;

    public abstract byte getHandlerId();

    final void setFTManager(FileTransferManager ftm) {
        this.ftManager = ftm;
    }

    boolean isUpstreamInvocable() {
        return this instanceof AcceptsUpstreamInvocations;
    }
}

