/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FTDatagram;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import com.raplix.rolloutexpress.net.ft.RequestAcceptor;
import com.raplix.rolloutexpress.net.ft.VerifiableStream;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.OutputStream;

class FTSendRequest
extends RequestAcceptor {
    private VerifiableStream store;
    private int curSeqId;
    private boolean eof = false;
    private boolean closed = false;

    private FTSendRequest(FileTransferManager ftm, RoxAddress source, int interactionId, VerifiableStream os) {
        super(ftm, source, interactionId);
        this.store = os;
        this.curSeqId = 1;
    }

    static FTSendRequest createSendRequest(FileTransferManager ftm, FTDatagram ftd) {
        try {
            DataId did = FileTransferManager.readRequestHeaderDataId(ftd);
            byte handlerId = FileTransferManager.readRequestHeaderHandlerId(ftd);
            if (Logger.isDebugEnabled(FTSendRequest.class)) {
                Logger.debug("create FTSendRequest for dataId:" + did + ":hndlr:" + handlerId, FTSendRequest.class);
            }
            OutputStream os = ftm.getHandler(handlerId, ftd.getPacket().getTransportInfo()).storeData(ftd.getPacket().getSourceId(), ftd.getPacket().getTransportInfo(), did);
            FTSendRequest fsr = new FTSendRequest(ftm, ftd.getPacket().getSourceId(), ftd.getInteractionId(), FileTransferManager.createVerifiableStream(os));
            return fsr;
        }
        catch (FileTransferException fte) {
            if (Logger.isErrorEnabled(FTSendRequest.class)) {
                Logger.error("Error accepting send request:" + ftd, fte, FTSendRequest.class);
            }
            ftm.sendError(ftd.getPacket().getSourceId(), ftd.getInteractionId(), (byte)1, fte);
            return null;
        }
    }

    protected void accept(FTDatagram ftd) {
        try {
            if (ftd.isSend() && ftd.isData() && ftd.getSequenceId() == this.curSeqId) {
                ++this.curSeqId;
                int offset = 31;
                int length = ftd.getBodyLength();
                if (ftd.getSequenceId() == 1) {
                    offset += 17;
                    length -= 17;
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Writing:off:" + offset + ":len:" + length, this);
                }
                this.store.write(ftd.getBody(), offset, length);
                if (ftd.isLast()) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("last packet:" + ftd, this);
                    }
                    this.store.close();
                    this.store.verifyCheckSum();
                    this.ftManager.sendAck(this.from, this.interactionId, (byte)1);
                    this.ftManager.requestDoneSEND(this);
                }
            } else if (ftd.isErr()) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Error packet received, closing output:" + ftd.getErrString(), this);
                }
                this.store.close();
            }
        }
        catch (IOException ie) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error writing the file to the output stream:", ie, this);
            }
            this.ftManager.sendError(this.from, this.interactionId, (byte)1, ie);
        }
        catch (FileTransferException fte) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error writing the file to the output stream:", fte, this);
            }
            this.ftManager.sendError(this.from, this.interactionId, (byte)1, fte);
        }
    }

    void errorDeliveringPacket(ErrorDetails errDetails) {
        if (Logger.isWarnEnabled(this)) {
            Logger.warn("Error delivering reply for this request:" + errDetails, this);
        }
    }
}

