/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.FTDatagram;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import com.raplix.rolloutexpress.net.ft.ResponseAcceptor;
import com.raplix.rolloutexpress.net.ft.VerifiableStream;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.util.logger.Logger;
import java.io.IOException;

class FTGetResponse
extends ResponseAcceptor {
    private int seqId = 1;
    private VerifiableStream output;
    private FileTransferManager ftManager;

    FTGetResponse(FileTransferManager ftm, RoxAddress dest, int interactionId, VerifiableStream os) {
        super(dest, interactionId);
        this.output = os;
        this.ftManager = ftm;
    }

    protected void accept(FTDatagram ftDatagram) throws MessageNotExpected {
        if (ftDatagram.isGet() && ftDatagram.isData() && !ftDatagram.isReq() && ftDatagram.getSequenceId() == this.seqId) {
            try {
                this.output.write(ftDatagram.getBody(), 31, ftDatagram.getBodyLength());
                ++this.seqId;
                if (ftDatagram.isLast()) {
                    this.output.close();
                    this.output.verifyCheckSum();
                    this.notifyWaiter();
                    return;
                }
                this.notifyResetTimeout();
            }
            catch (IOException ie) {
                block9: {
                    this.error = new FileTransferException(NetMessageCode.FT_ERROR_WRITING_OUTPUT, (Throwable)ie);
                    try {
                        this.output.close();
                    }
                    catch (IOException ioe) {
                        if (!Logger.isErrorEnabled(ioe)) break block9;
                        Logger.error("Error closing the output stream", ioe);
                    }
                }
                this.notifyWaiter();
                this.ftManager.sendError(this.destId, this.interactionId, (byte)66, ie);
            }
            catch (FileTransferException fte) {
                this.error = new FileTransferException(NetMessageCode.FT_ERROR_WRITING_OUTPUT, (Throwable)fte);
                this.notifyWaiter();
            }
        } else {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unexpected datagram in accept:" + ftDatagram, this);
            }
            throw new MessageNotExpected(NetMessageCode.FT_UNEXPECTED_GET_RESPONSE_PACKET, (Object[])new String[]{ftDatagram.toString(), this.toString()});
        }
    }
}

