/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.ft.ChecksumAppender;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FTDatagram;
import com.raplix.rolloutexpress.net.ft.FileDatagramDeliveryException;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import com.raplix.rolloutexpress.net.ft.RequestAcceptor;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.InputStream;

class FTGetRequest
extends RequestAcceptor
implements Runnable {
    private InputStream dataSource;
    private boolean eof;
    private ErrorDetails errDetails = null;

    private FTGetRequest(FileTransferManager ftm, RoxAddress from, int interactionId, InputStream ds) {
        super(ftm, from, interactionId);
        this.dataSource = ds;
    }

    public static FTGetRequest createGetRequest(FileTransferManager ftm, FTDatagram ftd) {
        try {
            byte handler = FileTransferManager.readRequestHeaderHandlerId(ftd);
            DataId dataId = FileTransferManager.readRequestHeaderDataId(ftd);
            if (Logger.isDebugEnabled(FTGetRequest.class)) {
                Logger.debug("createFTGetRequest:hndlr:" + handler + ":dataID:" + dataId, FTGetRequest.class);
            }
            ChecksumAppender ds = FileTransferManager.createChecksumAppender(ftm.getHandler(handler, ftd.getPacket().getTransportInfo()).fetchData(ftd.getPacket().getSourceId(), dataId, ftd.getPacket().getTransportInfo()));
            FTGetRequest fgr = new FTGetRequest(ftm, ftd.getPacket().getSourceId(), ftd.getInteractionId(), ds);
            return fgr;
        }
        catch (FileTransferException fte) {
            if (Logger.isErrorEnabled(FTGetRequest.class)) {
                Logger.error("Error accepting get request:" + ftd, fte, FTGetRequest.class);
            }
            ftm.sendError(ftd.getPacket().getSourceId(), ftd.getInteractionId(), (byte)2, fte);
            return null;
        }
    }

    protected void accept(FTDatagram ftd) throws MessageNotExpected {
        if (!ftd.isErr()) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unexpected packet in accept:" + ftd, this);
            }
            throw new MessageNotExpected(NetMessageCode.FT_UNEXPECTED_GET_DATAGRAM, (Object[])new String[]{ftd.toString()});
        }
        this.eof = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block22: {
            block21: {
                int seqId = 1;
                while (!this.eof) {
                    FTDatagram ftDatagram = new FTDatagram(this.from, this.interactionId, seqId, 6);
                    int bytesRead = 0;
                    int offset = 31;
                    int requestBytes = 1399 - offset;
                    while (true) {
                        if (offset >= 1399) break;
                        bytesRead = this.dataSource.read(ftDatagram.getBody(), offset, requestBytes);
                        if (bytesRead < 0) {
                            this.eof = true;
                            break;
                        }
                        offset += bytesRead;
                        requestBytes -= bytesRead;
                    }
                    if (this.eof) {
                        ftDatagram.setFlags((byte)(ftDatagram.getFlags() | 8));
                    }
                    ftDatagram.setBodyLength(offset - 31);
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Sending GETPacket:" + ftDatagram, this);
                    }
                    this.ftManager.sendFTMessage(ftDatagram);
                    this.resetTimeout();
                    Thread.yield();
                    if (this.errDetails != null) {
                        throw new FileDatagramDeliveryException(this.errDetails);
                    }
                    ++seqId;
                }
                Object var8_6 = null;
                try {
                    this.dataSource.close();
                }
                catch (IOException ie) {
                    if (!Logger.isWarnEnabled(this)) break block21;
                    Logger.warn("Error closing dataSource", ie, this);
                }
            }
            this.ftManager.requestDoneGET(this);
            {
                break block22;
                catch (IOException ioe) {
                    block23: {
                        if (Logger.isWarnEnabled(this)) {
                            Logger.warn("Error sending data for GET:", ioe, this);
                        }
                        this.ftManager.sendError(this.from, this.interactionId, (byte)2, ioe);
                        Object var8_7 = null;
                        try {
                            this.dataSource.close();
                        }
                        catch (IOException ie) {
                            if (!Logger.isWarnEnabled(this)) break block23;
                            Logger.warn("Error closing dataSource", ie, this);
                        }
                    }
                    this.ftManager.requestDoneGET(this);
                    break block22;
                }
                catch (TransportException te) {
                    block24: {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error sending GET data to source", te, this);
                        }
                        Object var8_8 = null;
                        try {
                            this.dataSource.close();
                        }
                        catch (IOException ie) {
                            if (!Logger.isWarnEnabled(this)) break block24;
                            Logger.warn("Error closing dataSource", ie, this);
                        }
                    }
                    this.ftManager.requestDoneGET(this);
                    break block22;
                }
                catch (FileTransferException fte) {
                    block25: {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error replying to GET request", fte, this);
                        }
                        Object var8_9 = null;
                        try {
                            this.dataSource.close();
                        }
                        catch (IOException ie) {
                            if (!Logger.isWarnEnabled(this)) break block25;
                            Logger.warn("Error closing dataSource", ie, this);
                        }
                    }
                    this.ftManager.requestDoneGET(this);
                }
            }
            catch (Throwable throwable) {
                block26: {
                    Object var8_10 = null;
                    try {
                        this.dataSource.close();
                    }
                    catch (IOException ie) {
                        if (!Logger.isWarnEnabled(this)) break block26;
                        Logger.warn("Error closing dataSource", ie, this);
                    }
                }
                this.ftManager.requestDoneGET(this);
                throw throwable;
            }
        }
    }

    void errorDeliveringPacket(ErrorDetails errDetails) {
        this.errDetails = errDetails;
    }
}

