/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportMessage;

class FTDatagram {
    private TransportMessage packet;
    public static final int SEQID_FIRST = 1;
    public static final byte VERSION = 1;
    public static final int HEADER_SIZE = 10;
    public static final int CONTENT_OFFSET = 31;
    public static final int MAX_OFFSET = 1399;
    public static final int MAX_ERR_STRING_LEN = 200;
    private static final String[] flagStrings = new String[]{"S", "G", "D", "L", "A", "E", "R", "0"};
    public static final byte FLAG_SEND = 1;
    public static final byte FLAG_GET = 2;
    public static final byte FLAG_DATA = 4;
    public static final byte FLAG_LAST = 8;
    public static final byte FLAG_ACK = 16;
    public static final byte FLAG_ERR = 32;
    public static final byte FLAG_REQ = 64;

    FTDatagram(RoxAddress destination, int interId, int seqId, byte flags) {
        this.packet = TransportMessage.createMessage(destination);
        this.setVersion((byte)1);
        this.setInteractionId(interId);
        this.setSequenceId(seqId);
        this.setFlags(flags);
    }

    FTDatagram(TransportMessage msg) {
        this.packet = msg;
    }

    void setVersion(byte b) {
        this.packet.body[21] = b;
    }

    void setFlags(byte b) {
        this.packet.body[21 + 1] = b;
    }

    void setInteractionId(int interactionId) {
        int offset = 21 + 2;
        this.packet.body[offset++] = (byte)(0xFF & interactionId >> 24);
        this.packet.body[offset++] = (byte)(0xFF & interactionId >> 16);
        this.packet.body[offset++] = (byte)(0xFF & interactionId >> 8);
        this.packet.body[offset++] = (byte)(0xFF & interactionId);
    }

    void setSequenceId(int seqId) {
        int offset = 21 + 2 + 4;
        this.packet.body[offset++] = (byte)(0xFF & seqId >> 24);
        this.packet.body[offset++] = (byte)(0xFF & seqId >> 16);
        this.packet.body[offset++] = (byte)(0xFF & seqId >> 8);
        this.packet.body[offset++] = (byte)(0xFF & seqId);
    }

    void setErrString(String errString) {
        if (errString.length() > 200) {
            errString = errString.substring(200);
        }
        byte[] bytes = errString.getBytes();
        System.arraycopy(bytes, 0, this.packet.body, 31, bytes.length);
        this.setBodyLength(bytes.length);
    }

    String getErrString() {
        if (this.isErr()) {
            return new String(this.packet.body, 31, this.getBodyLength());
        }
        return null;
    }

    byte getVersion() {
        return this.packet.body[21];
    }

    byte getFlags() {
        return this.packet.body[21 + 1];
    }

    int getInteractionId() {
        int offset = 21 + 2;
        int interId = (this.packet.body[offset++] & 0xFF) << 24 | (this.packet.body[offset++] & 0xFF) << 16 | (this.packet.body[offset++] & 0xFF) << 8 | this.packet.body[offset] & 0xFF;
        return interId;
    }

    int getSequenceId() {
        int offset = 21 + 2 + 4;
        int seqId = (this.packet.body[offset++] & 0xFF) << 24 | (this.packet.body[offset++] & 0xFF) << 16 | (this.packet.body[offset++] & 0xFF) << 8 | this.packet.body[offset] & 0xFF;
        return seqId;
    }

    int getBodyLength() {
        return this.packet.getLength() - 10;
    }

    void setBodyLength(int length) {
        this.packet.setLength(length + 10);
    }

    byte[] getBody() {
        return this.packet.body;
    }

    boolean isSend() {
        return (this.getFlags() & 1) > 0;
    }

    boolean isGet() {
        return (this.getFlags() & 2) > 0;
    }

    boolean isData() {
        return (this.getFlags() & 4) > 0;
    }

    boolean isLast() {
        return (this.getFlags() & 8) > 0;
    }

    boolean isAck() {
        return (this.getFlags() & 0x10) > 0;
    }

    boolean isErr() {
        return (this.getFlags() & 0x20) > 0;
    }

    boolean isReq() {
        return (this.getFlags() & 0x40) > 0;
    }

    String getFlagString() {
        byte flg = this.getFlags();
        int mask = 1;
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            if ((flg & mask << i) <= 0) continue;
            ret.append(flagStrings[i]);
        }
        return ret.toString();
    }

    TransportMessage getPacket() {
        return this.packet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FTDatagram:version=");
        sb.append(this.getVersion()).append(":flags=").append(this.getFlags()).append("|").append(this.getFlagString());
        sb.append(":interId=").append(this.getInteractionId());
        sb.append(":sequenceId=").append(this.getSequenceId());
        sb.append(":packet=").append(this.packet);
        return sb.toString();
    }
}

