/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.logger.Logger;

public class DataId
implements RPCSerializable {
    static final long serialVersionUID = -490599403826421661L;
    public static final int LENGTH = 16;
    private long id1;
    private long id2;

    public DataId() {
    }

    public DataId(long id1, long id2) {
        this.id1 = id1;
        this.id2 = id2;
    }

    public DataId(byte[] dataId, int offset) {
        if (dataId.length - offset < 16 && Logger.isErrorEnabled(this)) {
            Logger.error("Insufficient bytes in the dataId array:" + (dataId.length - offset), this);
        }
        this.id1 = (long)(dataId[offset++] & 0xFF) << 56 | (long)(dataId[offset++] & 0xFF) << 48 | (long)(dataId[offset++] & 0xFF) << 40 | (long)(dataId[offset++] & 0xFF) << 32 | (long)(dataId[offset++] & 0xFF) << 24 | (long)(dataId[offset++] & 0xFF) << 16 | (long)(dataId[offset++] & 0xFF) << 8 | (long)(dataId[offset++] & 0xFF);
        this.id2 = (long)(dataId[offset++] & 0xFF) << 56 | (long)(dataId[offset++] & 0xFF) << 48 | (long)(dataId[offset++] & 0xFF) << 40 | (long)(dataId[offset++] & 0xFF) << 32 | (long)(dataId[offset++] & 0xFF) << 24 | (long)(dataId[offset++] & 0xFF) << 16 | (long)(dataId[offset++] & 0xFF) << 8 | (long)(dataId[offset++] & 0xFF);
    }

    public byte[] getByteArray() {
        byte[] b = new byte[16];
        this.writeByteArray(b, 0);
        return b;
    }

    public long getId1() {
        return this.id1;
    }

    public long getId2() {
        return this.id2;
    }

    void writeByteArray(byte[] b, int offset) {
        if (b.length - offset < 16 && Logger.isErrorEnabled(this)) {
            Logger.error("Insufficient space in the supplied byte array:" + (b.length - offset), this);
        }
        b[offset++] = (byte)(0xFFL & this.id1 >> 56);
        b[offset++] = (byte)(0xFFL & this.id1 >> 48);
        b[offset++] = (byte)(0xFFL & this.id1 >> 40);
        b[offset++] = (byte)(0xFFL & this.id1 >> 32);
        b[offset++] = (byte)(0xFFL & this.id1 >> 24);
        b[offset++] = (byte)(0xFFL & this.id1 >> 16);
        b[offset++] = (byte)(0xFFL & this.id1 >> 8);
        b[offset++] = (byte)(0xFFL & this.id1);
        b[offset++] = (byte)(0xFFL & this.id2 >> 56);
        b[offset++] = (byte)(0xFFL & this.id2 >> 48);
        b[offset++] = (byte)(0xFFL & this.id2 >> 40);
        b[offset++] = (byte)(0xFFL & this.id2 >> 32);
        b[offset++] = (byte)(0xFFL & this.id2 >> 24);
        b[offset++] = (byte)(0xFFL & this.id2 >> 16);
        b[offset++] = (byte)(0xFFL & this.id2 >> 8);
        b[offset++] = (byte)(0xFFL & this.id2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataId) {
            DataId d = (DataId)obj;
            return d.id1 == this.id1 && d.id2 == this.id2;
        }
        return false;
    }

    public int hashCode() {
        long val = this.id1 ^ this.id2;
        return (int)((0xFFFFFFFF00000000L & val) >> 32) ^ (int)(0xFFFFFFFFFFFFFFFFL & val);
    }

    public String toString() {
        return this.getClass().getName() + ":id1:" + Long.toHexString(this.id1) + ":id2:" + Long.toHexString(this.id2);
    }
}

