/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;

public class ChecksumAppender
extends FilterInputStream {
    private boolean readAllInput = false;
    private byte[] checkSum;
    private int curPointer;

    public ChecksumAppender(InputStream is) throws FileTransferException {
        super(FileTransferManager.createDigestInputStream(is));
    }

    public long skip(long n) throws IOException {
        return 0L;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.readAllInput) {
            int val = super.read(b, off, len);
            if (val < 0) {
                this.readAllInput = true;
                this.checkSum = ((DigestInputStream)this.in).getMessageDigest().digest();
                this.curPointer = 0;
                len = len > this.checkSum.length ? this.checkSum.length : len;
                System.arraycopy(this.checkSum, this.curPointer, b, off, len);
                this.curPointer += len;
                return len;
            }
            return val;
        }
        int availableBytes = this.available();
        if (availableBytes == 0) {
            return -1;
        }
        len = len > availableBytes ? availableBytes : len;
        System.arraycopy(this.checkSum, this.curPointer, b, off, len);
        this.curPointer += len;
        return len;
    }

    public int available() throws IOException {
        if (this.readAllInput) {
            return this.checkSum.length - this.curPointer;
        }
        return super.available();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int val = this.read(b);
        if (val < 0) {
            return val;
        }
        return b[0];
    }
}

