/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.ft;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class CSOutputStream
extends FilterOutputStream {
    public final int mNumLastBytes;
    private byte[] buffer = new byte[1024];
    private int curPointer = 0;
    byte[] lastBytes;

    public CSOutputStream(OutputStream out, int numLastBytes) {
        super(out);
        this.mNumLastBytes = numLastBytes;
        this.lastBytes = new byte[this.mNumLastBytes];
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        if (len < this.buffer.length - this.curPointer) {
            System.arraycopy(bytes, off, this.buffer, this.curPointer, len);
            this.curPointer += len;
        } else if (len < this.mNumLastBytes) {
            int writeOff = this.curPointer - (this.mNumLastBytes - len);
            this.out.write(this.buffer, 0, writeOff);
            this.curPointer = this.mNumLastBytes - len;
            System.arraycopy(this.buffer, writeOff, this.buffer, 0, this.curPointer);
        } else {
            this.out.write(this.buffer, 0, this.curPointer);
            System.arraycopy(bytes, off + len - this.mNumLastBytes, this.buffer, 0, this.mNumLastBytes);
            this.curPointer = this.mNumLastBytes;
            this.out.write(bytes, off, len - this.mNumLastBytes);
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void flush() throws IOException {
        if (this.curPointer > this.mNumLastBytes) {
            this.out.write(this.buffer, 0, this.curPointer - this.mNumLastBytes);
            System.arraycopy(this.buffer, this.curPointer - this.mNumLastBytes, this.buffer, 0, this.mNumLastBytes);
            this.curPointer = this.mNumLastBytes;
        }
        super.flush();
    }

    public byte[] getLastBytes() {
        byte[] ret = new byte[this.mNumLastBytes];
        if (this.curPointer >= this.mNumLastBytes) {
            System.arraycopy(this.buffer, this.curPointer - this.mNumLastBytes, ret, 0, this.mNumLastBytes);
        } else {
            System.arraycopy(this.buffer, 0, ret, 0, this.curPointer);
            Arrays.fill(ret, this.curPointer, this.mNumLastBytes, (byte)0);
        }
        return ret;
    }

    public String toString() {
        return "cur:" + this.curPointer;
    }
}

