/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.command;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.command.DatagramAccumulator;
import com.raplix.rolloutexpress.net.command.DatagramOutputStream;
import com.raplix.rolloutexpress.net.command.IllegalProtocolState;
import com.raplix.rolloutexpress.net.command.InvalidDatagram;
import com.raplix.rolloutexpress.net.command.RRDatagram;
import com.raplix.rolloutexpress.net.command.RequestReply;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.util.logger.Logger;
import java.io.InputStream;
import java.io.OutputStream;

public class ServerRequest {
    private DatagramAccumulator request;
    private DatagramOutputStream reply;
    private TransportInfo transportInfo;
    private final int INBOUND_REQUEST_TIMEOUT_TASK_RANGE;
    private int timeOutCount;
    private final int STATUS_UPD_TASK_RANGE;
    private int statusUpdateMsgCount;

    ServerRequest(RequestReply rr, RRDatagram packet) throws InvalidDatagram {
        this.request = new DatagramAccumulator(rr, packet);
        this.reply = new DatagramOutputStream(rr, packet.getPacket().getSourceId(), packet.getInteractionId(), false);
        this.transportInfo = packet.getPacket().getTransportInfo();
        this.statusUpdateMsgCount = this.STATUS_UPD_TASK_RANGE = rr.STATUS_UPD_TASK_RANGE;
        this.timeOutCount = this.INBOUND_REQUEST_TIMEOUT_TASK_RANGE = rr.INBOUND_REQUEST_TIMEOUT_TASK_RANGE;
    }

    public RoxAddress getSource() {
        return this.request.getSourceId();
    }

    DatagramAccumulator getRequestAccumulator() {
        this.resetTimeOut();
        return this.request;
    }

    public int getInteractionId() {
        return this.request.getInteractionId();
    }

    public InputStream getInputStream() throws IllegalProtocolState {
        return this.request.getInputStream();
    }

    public OutputStream getOutputStream() throws IllegalProtocolState {
        return this.getReplyStream();
    }

    public TransportInfo getTransportInfo() {
        return this.transportInfo;
    }

    DatagramOutputStream getReplyStream() throws IllegalProtocolState {
        if (this.request.isClosed()) {
            return this.reply;
        }
        throw new IllegalProtocolState(NetMessageCode.COM_NO_REPLY_STREAM_INPUTSTREAM_OPEN);
    }

    synchronized boolean testTimeOut() {
        return --this.timeOutCount < 1;
    }

    private synchronized void resetTimeOut() {
        this.timeOutCount = this.INBOUND_REQUEST_TIMEOUT_TASK_RANGE;
    }

    synchronized boolean sendStatusUpdate() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("statusUpdVal:" + this.statusUpdateMsgCount, this);
        }
        if (--this.statusUpdateMsgCount <= 0) {
            this.statusUpdateMsgCount = this.STATUS_UPD_TASK_RANGE;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + ":Source:" + this.getSource() + ":Interaction:" + this.getInteractionId();
    }
}

