/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.command;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.command.ClientRequest;
import com.raplix.rolloutexpress.net.command.DatagramAccumulator;
import com.raplix.rolloutexpress.net.command.DatagramOutputStream;
import com.raplix.rolloutexpress.net.command.IllegalProtocolState;
import com.raplix.rolloutexpress.net.command.InboundRequestKey;
import com.raplix.rolloutexpress.net.command.InvalidDatagram;
import com.raplix.rolloutexpress.net.command.ProtocolException;
import com.raplix.rolloutexpress.net.command.RRDatagram;
import com.raplix.rolloutexpress.net.command.ServerRequest;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.ProtocolManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportMessage;
import com.raplix.util.logger.Logger;
import com.raplix.util.threadpool.NoMoreThreads;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public abstract class RequestReply
extends ProtocolManager {
    protected NetSubsystem netSubsystem;
    private int commandId = 0;
    private Hashtable outboundRequests = null;
    private Hashtable inboundRequests = null;
    private HashSet requestsBeingProcessed = new HashSet();
    public final int COMMAND_TIMEOUT;
    public final int STATUS_UPD_TASK_RANGE;
    public final int INBOUND_REQUEST_TIMEOUT_TASK_RANGE;

    protected RequestReply(NetSubsystem nss) throws ConfigurationException {
        this.netSubsystem = nss;
        this.outboundRequests = new Hashtable();
        this.inboundRequests = new Hashtable();
        this.COMMAND_TIMEOUT = nss.getCommandTimeout();
        this.STATUS_UPD_TASK_RANGE = nss.getConfigRRStatusMsgTaskRange();
        this.INBOUND_REQUEST_TIMEOUT_TASK_RANGE = nss.getConfigRRInboundRequestTimeoutTaskRange();
        nss.getScheduler().scheduleTask(new Runnable(){

            public void run() {
                RequestReply.this.timeoutInboundRequests();
            }

            public String toString() {
                return "RequestReply:Inbound request timeout";
            }
        }, nss.getConfigRRInboundRequestTimeoutTaskInterval());
        nss.getScheduler().scheduleTask(new Runnable(){

            public void run() {
                RequestReply.this.sendStatusUpdates();
            }

            public String toString() {
                return "RequestReply:Send Status messages";
            }
        }, nss.getConfigRRStatusMsgTaskInterval());
    }

    private synchronized int allocateId() {
        if (this.commandId < Integer.MAX_VALUE) {
            return ++this.commandId;
        }
        this.commandId = 1;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientRequest initiateRequest(RoxAddress dest) throws ProtocolException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("initiateRequest:for dest:" + dest, this);
        }
        int requestId = this.allocateId();
        ClientRequest cr = new ClientRequest(this, dest, requestId);
        Hashtable hashtable = this.outboundRequests;
        synchronized (hashtable) {
            this.outboundRequests.put(new Integer(requestId), cr);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Added new outbound request:" + cr, this);
        }
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final InputStream getResponse(ClientRequest req) throws ProtocolException {
        Hashtable hashtable;
        InputStream inputStream;
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("getResponse:for ClientRequest:" + req, this);
            }
            DatagramAccumulator dac = req.getReplyAccumulator();
            dac.waitForResponse();
            inputStream = dac.getInputStream();
            Object var5_4 = null;
            hashtable = this.outboundRequests;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Hashtable hashtable2 = this.outboundRequests;
            synchronized (hashtable2) {
                this.outboundRequests.remove(new Integer(req.getInteractionId()));
            }
            throw throwable;
        }
        synchronized (hashtable) {
            this.outboundRequests.remove(new Integer(req.getInteractionId()));
        }
        return inputStream;
    }

    protected abstract void handleRequest(ServerRequest var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void receiveMessage(TransportMessage msg) throws MessageNotExpected {
        try {
            RRDatagram datagram = new RRDatagram(msg);
            if (datagram.getVersion() != 1) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Packet with unsupported version:" + datagram, this);
                }
                throw new MessageNotExpected(NetMessageCode.COM_PACKET_UNSUPPORTED_VERSION, (Object[])new String[]{String.valueOf(1), String.valueOf(datagram.getVersion())});
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("receiveMessage:" + datagram, this);
            }
            if (datagram.isReply()) {
                ClientRequest cr = (ClientRequest)this.outboundRequests.get(new Integer(datagram.getInteractionId()));
                if (cr != null) {
                    DatagramAccumulator dac = cr.getReplyAccumulator();
                    dac.append(datagram);
                    return;
                }
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Unexpected packet:No pending request found" + datagram, this);
                }
                throw new MessageNotExpected(NetMessageCode.COM_NO_PENDING_REQUEST_FOR_REPLY_PACKET, (Object[])new String[]{datagram.toString()});
            }
            if (datagram.isRequest()) {
                InboundRequestKey irk = new InboundRequestKey(msg.getSourceId(), datagram.getInteractionId());
                ServerRequest sr = (ServerRequest)this.inboundRequests.get(irk);
                if (sr != null) {
                    sr.getRequestAccumulator().append(datagram);
                    return;
                }
                if (datagram.getSequenceId() == 1) {
                    sr = new ServerRequest(this, datagram);
                    this.inboundRequests.put(irk, sr);
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Created & Added new server request:" + sr + ":table:" + this.inboundRequests, this);
                    }
                    sr.getRequestAccumulator().append(datagram);
                    return;
                }
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Unexpected packet:No record in the inbound requests and sequenceId != 1:packet:" + datagram, this);
                }
                throw new MessageNotExpected(NetMessageCode.COM_NO_EXISTING_REQUEST_FOR_REQUEST_PACKET, (Object[])new String[]{datagram.toString()});
            }
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("Illegal packet:Neither request nor reply:packet:" + datagram, this);
            }
            throw new MessageNotExpected(NetMessageCode.COM_PACKET_NEITHER_REQ_NOT_REPLY, (Object[])new String[]{datagram.toString()});
        }
        catch (IllegalProtocolState ips) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Illegal protocol state receiving message:" + msg, ips, this);
            }
            throw new MessageNotExpected(NetMessageCode.COM_ILLEGAL_PROTOCOL_STATE, (Throwable)ips, (Object[])new String[]{msg.toString()});
        }
        catch (InvalidDatagram id) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("Invalid datagram:" + msg, id, this);
            }
            throw new MessageNotExpected(NetMessageCode.COM_INVALID_DATAGRAM, (Throwable)id, (Object[])new String[]{msg.toString()});
        }
    }

    protected void errorDeliveringMessage(TransportMessage originalPacketFragment, ErrorDetails errDetails) {
        block8: {
            try {
                RRDatagram datagram = new RRDatagram(originalPacketFragment);
                if (datagram.isRequest()) {
                    ClientRequest cr = (ClientRequest)this.outboundRequests.get(new Integer(datagram.getInteractionId()));
                    if (cr != null) {
                        DatagramAccumulator dac = cr.getReplyAccumulator();
                        dac.notifyError(errDetails);
                    } else if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Error packet received but no pending request found" + datagram, this);
                    }
                } else if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Error delivering reply packet:" + datagram, this);
                }
            }
            catch (Exception e) {
                if (!Logger.isWarnEnabled(this)) break block8;
                Logger.warn("Exception when handling Transport delivery error", e, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutInboundRequests() {
        ServerRequest sr = null;
        Vector<InboundRequestKey> tmp = new Vector<InboundRequestKey>();
        Hashtable hashtable = this.inboundRequests;
        synchronized (hashtable) {
            Enumeration<Object> enu = this.inboundRequests.elements();
            while (enu.hasMoreElements()) {
                sr = (ServerRequest)enu.nextElement();
                if (!sr.testTimeOut()) continue;
                tmp.add(new InboundRequestKey(sr.getSource(), sr.getInteractionId()));
            }
            enu = tmp.elements();
            while (enu.hasMoreElements()) {
                Object obj = enu.nextElement();
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Time out stale inbound request:" + obj, this);
                }
                this.inboundRequests.remove(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatusUpdates() {
        Iterator requests;
        ServerRequest sr = null;
        RRDatagram datagram = null;
        LinkedList<ServerRequest> values = new LinkedList<ServerRequest>();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Checking to send status updates", this);
        }
        HashSet hashSet = this.requestsBeingProcessed;
        synchronized (hashSet) {
            requests = this.requestsBeingProcessed.iterator();
            while (requests.hasNext()) {
                sr = (ServerRequest)requests.next();
                if (!sr.sendStatusUpdate()) continue;
                values.add(sr);
            }
        }
        requests = values.iterator();
        while (requests.hasNext()) {
            sr = (ServerRequest)requests.next();
            try {
                datagram = new RRDatagram(sr.getSource(), sr.getInteractionId(), 0, 10);
                datagram.setBodyLength(0);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Sending status update message:" + datagram, this);
                }
                this.sendMessage(datagram.getPacket());
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) continue;
                Logger.error("Error sending status update message:" + datagram, e, this);
            }
        }
    }

    void doneAccumulating(DatagramAccumulator dac) throws MessageNotExpected {
        block11: {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("doneAccumulating:" + dac, this);
            }
            try {
                if (dac.isRequest()) {
                    InboundRequestKey irk = new InboundRequestKey(dac.getSourceId(), dac.getInteractionId());
                    ServerRequest sr = (ServerRequest)this.inboundRequests.get(irk);
                    if (sr == null) {
                        Logger.warn("doneAccumulating notification received for a non-existing server request from DatagramAccumulator:" + dac + ":table:" + this.inboundRequests, this);
                        throw new MessageNotExpected(NetMessageCode.COM_NO_REQUEST_FOR_DONE_ACCUMULATING_NOTIFY, (Object[])new String[]{dac.toString(), this.inboundRequests.toString()});
                    }
                    RequestServer requestServer = new RequestServer(sr);
                    this.inboundRequests.remove(irk);
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Removed inbound request:" + irk, this);
                    }
                    try {
                        this.netSubsystem.getThreadPool().start(requestServer);
                        break block11;
                    }
                    catch (NoMoreThreads nmt) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Cannot create threads to handle requests:", nmt, this);
                        }
                        throw new MessageNotExpected(NetMessageCode.COM_THREADS_EXHAUSTED, (Throwable)nmt);
                    }
                }
                dac.notifyWaiters();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Received reply for:" + dac, this);
                }
            }
            catch (IllegalProtocolState e) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Exception handling doneAccumulating notification", e, this);
                }
                throw new MessageNotExpected(NetMessageCode.COM_ILLEGAL_PROTOCOL_STATE_DONE_ACCUMULATING, (Throwable)e, (Object[])new String[]{dac.toString()});
            }
        }
    }

    void outputClosed(DatagramOutputStream dos) throws IllegalProtocolState, TransportException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("outputClosed:" + dos, this);
        }
        Iterator iterator = dos.getIterator();
        RRDatagram datagram = null;
        while (iterator.hasNext()) {
            datagram = (RRDatagram)iterator.next();
            this.sendMessage(datagram.getPacket());
            Thread.yield();
        }
    }

    public String toString() {
        return this.getClass().getName() + "Current commandid:" + this.commandId;
    }

    private class RequestServer
    implements Runnable {
        ServerRequest serverRequest;

        RequestServer(ServerRequest sr) {
            this.serverRequest = sr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Invoking handleRequest:" + this.serverRequest, this);
                    }
                    HashSet hashSet = RequestReply.this.requestsBeingProcessed;
                    synchronized (hashSet) {
                        RequestReply.this.requestsBeingProcessed.add(this.serverRequest);
                    }
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    RequestReply.this.handleRequest(this.serverRequest);
                }
                catch (Exception e) {
                    if (Logger.isWarnEnabled(this)) {
                        Logger.warn("Unexpected exception when handling request:" + this.serverRequest, e, this);
                    }
                    Object var4_4 = null;
                    HashSet hashSet = RequestReply.this.requestsBeingProcessed;
                    synchronized (hashSet) {
                        RequestReply.this.requestsBeingProcessed.remove(this.serverRequest);
                        return;
                    }
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                HashSet hashSet2 = RequestReply.this.requestsBeingProcessed;
                synchronized (hashSet2) {
                    RequestReply.this.requestsBeingProcessed.remove(this.serverRequest);
                    throw throwable;
                }
            }
            HashSet hashSet = RequestReply.this.requestsBeingProcessed;
            synchronized (hashSet) {
                RequestReply.this.requestsBeingProcessed.remove(this.serverRequest);
                return;
            }
        }

        public String toString() {
            return "RequestReply:RequestServer";
        }
    }
}

